<?php

namespace Modules\Product\database\seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use Modules\Product\Models\Product;

class ProductsTableSeeder extends Seeder
{
    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        \DB::table('products')->delete();

        $data = [

            1 => [
                'id' => 2,
                'name' => 'Hair Fall Control Shampoo',
                'slug' => 'hair-fall-control-shampoo-4ofnb',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Lotus Organics Hair Fall Control Shampoo features a formulation of 100% Certified Organic Rosemary Oil, which helps reduce hair thinning &amp; hair fall. Its protective moisture replenishing formula combats signs of damage &amp; aging due to heat styling &amp; external environmental aggressors to set out strengthened and restored healthy tresses.</span></p>',
                'brand_id' => 1,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 80.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 110,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/hair_fall_control_shampoo_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 09:42:05',
                'updated_at' => '2023-09-26 09:42:05',
                'deleted_at' => null,
            ],
            2 => [
                'id' => 3,
                'name' => 'Growth Protein Shampoo',
                'slug' => 'growth-protein-shampoo-gwwih',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">The Bella Vita Organic Growth Protein Shampoo is here to help you stop hair fall and strengthen your hair. 👩🏻</span></p><p><span style="color: rgb(0, 0, 0);">Say good bye to dandruff with natural ingredients like Fenugreek, Onion and lots of vitamins and minerals.🧅</span></p><p><span style="color: rgb(0, 0, 0);">This natural and Ayurvedic blend contains Fenugreek, which is rich in folic acid and helps treat scalp issues like dryness &amp; thinning. Onion, a hair care hero ingredient, is loaded with sulphur, stimulates keratin production, nourishes hair follicles and boosts hair growth. 😍</span></p>',
                'brand_id' => 2,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 80.0,
                'discount_value' => 5.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1693526400,
                'discount_end_date' => 1698710400,
                'sell_target' => null,
                'stock_qty' => 70,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 0,
                'max_purchase_qty' => 0,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 0,
                'express_delivery_hours' => 0,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/growth_protein_shampoo_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 09:46:53',
                'updated_at' => '2023-09-26 10:29:55',
                'deleted_at' => null,
            ],
            3 => [
                'id' => 4,
                'name' => 'Goodrej Professional Probio Keratin Revive Shampoo & Revive Mask',
                'slug' => 'goodrej-professional-probio-keratin-revive-shampoo-revive-mask-zgeu7',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Regular use of this duo strengthens your hair leaving it smooth, supple &amp; shiny.</span></p><p><span style="color: rgb(0, 0, 0);">Infused with hydrolyzed keratin.</span></p><p><span style="color: rgb(0, 0, 0);">Specially created for Indian hair.</span></p><p><span style="color: rgb(0, 0, 0);">No-added Parabens, No Animal Testing On Finished Products.</span></p><p><span style="color: rgb(0, 0, 0);">Net Quantity - 2.</span></p>',
                'brand_id' => 3,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 30.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/godrej_professional_probio_keratin_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 09:50:53',
                'updated_at' => '2023-09-26 09:50:57',
                'deleted_at' => null,
            ],
            4 => [
                'id' => 5,
                'name' => 'Goodrej Professional Probio Honey Moisture Hair Mask| For Dry & Damaged Hair | No Sulphate',
                'slug' => 'goodrej-professional-probio-honey-moisture-hair-mask-for-dry-damaged-hair-no-sulphate-gixk4',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Contains: 1 unit of Godrej Professional Probio Honey Moisture Hair Mask (200g)</span></p><p><span style="color: rgb(0, 0, 0);">Goodness of honey and nourishing oil: Nourishes all types of hair, whilst reducing frizz</span></p><p><span style="color: rgb(0, 0, 0);">No sulphate, No paraben, No sls, No sles: Free from harmful chemicals like Sulphate, Paraben, SLS and SLES; Hasn’t been tested on animals</span></p><p><span style="color: rgb(0, 0, 0);">Restores damaged hair: Revitalizes, reinforces and strengthens hair and makes them manageable</span></p><p><span style="color: rgb(0, 0, 0);">Moisturizes hair: Moisturizes your hair and makes them soft and shiny</span></p><p><span style="color: rgb(0, 0, 0);">Protects from harsh elements: Prevents damage from pollution and heat styling</span></p><p><span style="color: rgb(0, 0, 0);">Colour protect formula: With a special blend of unique colour protect formula that can be used for colour-treated hair</span></p>',
                'brand_id' => 3,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 18.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 60,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/godrej_professional_probio_honey_moisture_hair_mask_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 09:54:53',
                'updated_at' => '2023-09-26 09:54:53',
                'deleted_at' => null,
            ],
            5 => [
                'id' => 6,
                'name' => 'Schhwarzzkopf Professional Spa Essence Nourishing Shampoo',
                'slug' => 'schhwarzzkopf-professional-spa-essence-nourishing-shampoo-jxtc0',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">With the Schhwarzkopf Professional Spa Essence Nourishing Shampoo, bid goodbye to hair fall, damaged and lifeless hair! This shampoo nourishes your hair while repairing its damaged structure and restoring that natural shine to it.</span></p><p><span style="color: rgb(0, 0, 0);">The Spa Essence range is created with a special Hydrolyzed Keratin technology that can penetrate the hair and directly work on repairing any damage to the hair from within. This nourishing shampoo contains amino acids and active cleansing agents which gently removes all the impurities from the scalp as well as the strands.</span></p>',
                'brand_id' => 1,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 56.0,
                'max_price' => 56.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 40,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/schwarzkopf_professional_spa_shampoo_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 09:57:08',
                'updated_at' => '2023-09-26 09:57:08',
                'deleted_at' => null,
            ],
            6 => [
                'id' => 7,
                'name' => 'Ketein Natural Hair Holding Spray',
                'slug' => 'ketein-natural-hair-holding-spray-qbvnv',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-100% Alcohol Free: Ktein Hair Holding Spray is made 100% free of alcohol, it can be safely used on daily basis without harming or drying the hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Made with Natural Ingredients: The product contains vital ingredients like onion, flaxseeds, chia seeds, aloe gel &amp; more which naturally holds the hair without harming the texture of the hair. To enhance the efficiency of the product, hair nurturing ingredients like onion, avocado, mulberry, hibiscus, thyme, argan oil, macadamia oil are used.</span></p><p><span style="color: rgb(0, 0, 0);">-Mild Hold for Daily Styling: Ktein Hair Holding Spray is for mild holding and setting of hair on daily basis. Can be used to maintain your blow-dried hair and to set the style of your hair. Also useful for setting the baby hair and to get a sleek look. Front and side flicks can be easily set an maintained with Ktein Hair Holding Spray.</span></p><p><span style="color: rgb(0, 0, 0);">-No Harmful Ingredients: This product contains No parabens, No sulphates, No Siicones, No Synthetic Colours-</span></p>',
                'brand_id' => 2,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 25.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/ktein_natural_hair_holding_spray_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 09:59:55',
                'updated_at' => '2023-09-26 09:59:55',
                'deleted_at' => null,
            ],
            7 => [
                'id' => 8,
                'name' => 'Sett Wett Extreme Hold, Hair Spray for Men, Style-Spray-Freeze,Bottle & Set Wet Cool Hold Strength Hair Gel',
                'slug' => 'sett-wett-extreme-hold-hair-spray-for-men-style-spray-freezebottle-set-wet-cool-hold-strength-hair-gel-elbuh',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Set wet hair spray for men-extreme hold sets your hairstyle so that no strand is out of place.</span></p><p><span style="color: rgb(0, 0, 0);">-This Set wet hair spray for men is non-sticky and sets your hair in place without weighing it down</span></p><p><span style="color: rgb(0, 0, 0);">-When used after styling with gel, wax, clay or pomade, the set wet hair spray gives an extra strong hold to maintain your hairstyle all day long</span></p><p><span style="color: rgb(0, 0, 0);">-This hair gel for men is your best friend when it comes to quickly styling your hair for a casual hangout with friends and give you a natural shine for a sada sexy vibe</span></p><p><span style="color: rgb(0, 0, 0);">-The set wet hair gel for men gives your hair the level of hold that allows it to stay slick and look effortless the entire day</span></p>',
                'brand_id' => 3,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 30.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/haircare_products/set_wet_extreme_hold_spray_hair_gel_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:02:00',
                'updated_at' => '2023-09-26 10:02:00',
                'deleted_at' => null,
            ],
            8 => [
                'id' => 9,
                'name' => 'Laccto Calaamine Cucumber Face Toner with Green Tea & Niacinamide for cool and hydrated skin. Tightens pores & evens skin tone. Suitable for Oily skin. No Sulphate, No Alcohol',
                'slug' => 'laccto-calaamine-cucumber-face-toner-with-green-tea-niacinamide-for-cool-and-hydrated-skin-tightens-pores-evens-skin-tone-suitable-for-oily-skin-no-sulphate-no-alcohol-eljix',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Item Form: Drop</span></p><p><span style="color: rgb(0, 0, 0);"></span></p><p><span style="color: rgb(0, 0, 0);">-Material Type: Sulfate Free, Alcohol Free, Paraben Free</span></p><p><span style="color: rgb(0, 0, 0);">-Product Benefits: Toner deep cleanses and tightens pores, Cucumber extracts, green tea extracts</span></p><p><span style="color: rgb(0, 0, 0);">-Recommended: Uses For Product Toning</span></p>',
                'brand_id' => 1,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 48.0,
                'max_price' => 48.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/lacto_calamine_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:04:31',
                'updated_at' => '2023-09-26 10:04:31',
                'deleted_at' => null,
            ],
            9 => [
                'id' => 10,
                'name' => 'mCaaffeine Alcohol Free Green Tea Face Toner for Pore Tightening & Improving Skin Texture | Toner With Fruit-AHA Mix & Caffeine for Glowing Skin | For All Skin Types',
                'slug' => 'mcaaffeine-alcohol-free-green-tea-face-toner-for-pore-tightening-improving-skin-texture-toner-with-fruit-aha-mix-caffeine-for-glowing-skin-for-all-skin-types-g8llm',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Mildly exfoliates: Enriched with Fruit AHA Mix, this natural toner mildly exfoliates dead skin. Antioxidants rich Green Tea in the toner help soothe inflammation, and superfood Caffeine reduces redness &amp; inflammation.</span></p><p><span style="color: rgb(0, 0, 0);">-Improves skin texture: The need for a perfect skin texture is addressed by potent ingredients in this toner. Fruit AHA Mix improves skin’s texture, Green Tea controls oil, and Caffeine naturally soothes &amp; tones the skin.</span></p><p><span style="color: rgb(0, 0, 0);">-Tightens pores: Loaded with Fruit AHA Mix helps this toner tighten the pores, and Green Tea helps reduce the appearance of pores.</span></p><p><span style="color: rgb(0, 0, 0);">-Great for your skin &amp; the planet: Ideal for both men &amp; women, Toner with Fruit AHA Mix &amp; Green Tea is Natural, PETA Certified, 100% Vegan and free from Alcohol, Paraben, SLS and all other harmful constituents. It is FDA-approved, dermatologically tested and has Zero Plastic Footprint</span></p>',
                'brand_id' => 4,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 150.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 25,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/mcaffeine_alcohol_free_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:06:58',
                'updated_at' => '2023-09-26 10:06:58',
                'deleted_at' => null,
            ],
            10 => [
                'id' => 11,
                'name' => 'Dott & Keey Vitamin C + E Sorbet Super Bright Moisturizer for Face | Vitamin C Face Cream For Glowing Skin | Fades Pigmentation & Dark Spots, Reduces Skin Dullness | Oil Free & Lightweight',
                'slug' => 'dott-keey-vitamin-c-e-sorbet-super-bright-moisturizer-for-face-vitamin-c-face-cream-for-glowing-skin-fades-pigmentation-dark-spots-reduces-skin-dullness-oil-free-lightweight-st6cf',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-A lightweight, cream with three types of vitamin C- 100% natural vitamin C from Kakadu Plum, Ethyl Ascorbic Acid &amp; Sodium Ascorbyl Phosphate.</span></p><p><span style="color: rgb(0, 0, 0);">-An antioxidant-rich cream, it helps reduce dullness &amp; intensely moisturizes for super-soft, youthful glowing skin.</span></p><p><span style="color: rgb(0, 0, 0);">-The goodness of Vitamin E protects skin from environmental aggressors to improve overall skin texture &amp; complexion.</span></p><p><span style="color: rgb(0, 0, 0);">-Neutralizes free radicals &amp; boosts collagen to fade fine lines, wrinkles &amp; dark spots caused by sun exposure.</span></p><p><span style="color: rgb(0, 0, 0);">-Additionally, it gently exfoliates &amp; fights acne-causing bacteria for smoother, clearer skin.</span></p><p><span style="color: rgb(0, 0, 0);">-Made with the goodness of Kakadu Plum, Ethyl Ascorbic Acid &amp; Sodium Ascorbic Phosphate, fades dark spots &amp; hyperpigmentation</span></p>',
                'brand_id' => 5,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 45.0,
                'max_price' => 59.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/dot_key_vitamin_c_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:12:22',
                'updated_at' => '2023-09-26 10:12:22',
                'deleted_at' => null,
            ],
            11 => [
                'id' => 12,
                'name' => 'Gaernier Skin Naturals, Face Serum, Increases Skin\'s Glow Instantly and Reduces Spots Overtime, Bright Complete Vitamin C Booster',
                'slug' => 'gaernier-skin-naturals-face-serum-increases-skins-glow-instantly-and-reduces-spots-overtime-bright-complete-vitamin-c-booster-zro5u',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Face serum suitable for all skin types</span></p><p><span style="color: rgb(0, 0, 0);">-Instantly combats a dull skin tone and reduces dark spots when used regularly</span></p><p><span style="color: rgb(0, 0, 0);">-How to use: Cleanse skin using a face wash, Apply 3-4 drops of serum and spread evenly over the face and neck using gentle tapping motions, Use twice a day and follow up with moisturising creams</span></p><p><span style="color: rgb(0, 0, 0);">-Enriched with lemon extracts and 30 times the amount of Vitamin C of Garnier\'s Bright Complete face creams to combat dark spots</span></p>',
                'brand_id' => 5,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 80.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/garnier_skin_naturals_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:14:12',
                'updated_at' => '2023-09-26 10:14:12',
                'deleted_at' => null,
            ],
            12 => [
                'id' => 13,
                'name' => 'Natural wash Sun Defence Sunscreen SPF 50 PA++ UVA/UVB Clinically Approved | Lightweight Quick Absorb Sun Protection Cream/Made with Natural Ingredients',
                'slug' => 'natural-wash-sun-defence-sunscreen-spf-50-pa-uvauvb-clinically-approved-lightweight-quick-absorb-sun-protection-creammade-with-natural-ingredients-xv5wg',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Natural sun defence sunscreen SPF 50 cream for Indian skin with Jojoba oil &amp; cucumber extract</span></p><p><span style="color: rgb(0, 0, 0);">-This clinically approved sunscreen cream may protects against sun and harmful UV rays, suitable for all skin types</span></p><p><span style="color: rgb(0, 0, 0);">-It is herbal as it has a non-chemical formula with ingredients such as cucumber extracts, saffron, licorice, jojoba oil and vitamin E</span></p><p><span style="color: rgb(0, 0, 0);">-This sunscreen helps to gives a matte finish and doesn’t give sticky feel like other creams</span></p>',
                'brand_id' => 3,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 38.0,
                'max_price' => 38.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/tnw_the_natural_wash_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:16:02',
                'updated_at' => '2023-09-26 10:16:02',
                'deleted_at' => null,
            ],
            13 => [
                'id' => 14,
                'name' => 'Sunscreen Spray SPF-60 PA+++ | For UVA & UVB Protection',
                'slug' => 'sunscreen-spray-spf-60-pa-for-uva-uvb-protection-ftzrs',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-SPF PA++60 - VauriiC SPF Pro++ Sunscreen Protection Spray is a product that provides excellent protection against both UVA and UVB rays with a high SPF PA++60 rating.</span></p><p><span style="color: rgb(0, 0, 0);">-No White Cast - One of the key features of VauriiC SPF Pro++ Sunscreen Spray is its "No White Cast" formula. This means that the sunscreen does not leave behind a visible white residue on the skin after application, which can be a common issue with some sunscreens.</span></p><p><span style="color: rgb(0, 0, 0);">-Protect + Glow - Another notable feature of VauriiC SPF Pro++ is its "Protect + Glow" formula. In addition to providing sun protection, this sunscreen is designed to give the skin a radiant and healthy-looking glow. T</span></p><p><br></p>',
                'brand_id' => 1,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/vauriic_sunscreen_spray_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:18:31',
                'updated_at' => '2023-09-26 10:18:31',
                'deleted_at' => null,
            ],
            14 => [
                'id' => 15,
                'name' => 'Dott & Keey Watermelon Hyaluronic Cooling Sunscreen SPF 50 PA+++| for Oily, Normal & Combination Skin | UV + Blue Light Protection',
                'slug' => 'dott-keey-watermelon-hyaluronic-cooling-sunscreen-spf-50-pa-for-oily-normal-combination-skin-uv-blue-light-protection-a6x9y',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Instantly cools &amp; hydrates skin: Daily wear, instantly cooling sunscreen with SPF 50+++ for smooth, luminous &amp; protected skin every day.</span></p><p><span style="color: rgb(0, 0, 0);">-Indoor &amp; outdoor protection: Powered by UV filters to protect skin against damaging UVA, UVB, blue light, IR &amp; HEV rays.</span></p><p><span style="color: rgb(0, 0, 0);">-Provides better vitamin d absorption: Promotes better absorption of Vitamin D into the skin, making it beneficial to be in the sun.</span></p><p><span style="color: rgb(0, 0, 0);">-Treats dullness &amp; uneven skin tone: Infused with Watermelon to fight dullness, treat uneven skin tone &amp; correct uneven skin texture</span></p><p><span style="color: rgb(0, 0, 0);">-Smoothens uneven skin texture: Infused with Hyaluronic Acid to provide lightweight hydration without any greasiness for a dewy, silky finish.</span></p><p><br></p>',
                'brand_id' => 5,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 29.0,
                'max_price' => 29.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/dot_key_watermelon_sunscreen_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:20:32',
                'updated_at' => '2023-09-26 10:20:32',
                'deleted_at' => null,
            ],
            15 => [
                'id' => 16,
                'name' => 'Nykaaa Clay It Cool Pore Perfect Clay Mask',
                'slug' => 'nykaaa-clay-it-cool-pore-perfect-clay-mask-8lntx',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">-Give your skincare regime a boost with Nykaaa Clay It Cool! Clay Masks. This multitasking mask, comes in 7 variants with ingredients that target specific skin concerns. So treat your skin to the ultimate TLC with our clay masks and say hello to supple, rejuvenated skin!</span></p><p><span style="color: rgb(0, 0, 0);">-Purifying pore cleanse mask</span></p><p><span style="color: rgb(0, 0, 0);">-Micromilled highest grade clay</span></p><p><span style="color: rgb(0, 0, 0);">-Botanical nutrition</span></p><p><span style="color: rgb(0, 0, 0);">-Detan &amp; detoxif</span></p><p><span style="color: rgb(0, 0, 0);">-Easy five minute ritual</span></p><p><span style="color: rgb(0, 0, 0);">-Hydrates</span></p><p><span style="color: rgb(0, 0, 0);">-Exfoliates, brightens and detoxifies</span></p><p><span style="color: rgb(0, 0, 0);">-Tames oily skin</span> </p>',
                'brand_id' => 6,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 56.0,
                'max_price' => 56.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/nykaa_clay_it_cool_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:22:00',
                'updated_at' => '2023-09-26 10:22:00',
                'deleted_at' => null,
            ],
            16 => [
                'id' => 17,
                'name' => 'Dott & Keey Anti-Acne Salicylic Green Clay Face Mask- Reduces Dark Spots And Balances Oil & Sebum',
                'slug' => 'dott-keey-anti-acne-salicylic-green-clay-face-mask-reduces-dark-spots-and-balances-oil-sebum-sjtpu',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-This green clay mask provides intense detoxifying treatment against pollution, ageing and acne to naturally purify your skin.</span></p><p><span style="color: rgb(0, 0, 0);">-Acting as a natural facial pore cleaner and blackhead remover, this green clay face pack also works as an anti pollution mask, to nullify the effect of pollution on the skin while simultaneously treating breakouts and blemishes.</span></p><p><span style="color: rgb(0, 0, 0);">-Contains matcha tea and tamanu oil that detoxifies skin and provides advanced anti acne solution and french green clay that accelerates anti ageing process.</span></p><p><span style="color: rgb(0, 0, 0);">-Preventing dull skin due to the effects of pollution, this non comedogenic face mask leaves skin feeling energized, smooth and radiant.</span></p>',
                'brand_id' => 5,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 20.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 70,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/dot_key_anti_acne_salicylic_green_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:25:11',
                'updated_at' => '2023-09-26 10:25:11',
                'deleted_at' => null,
            ],
            17 => [
                'id' => 18,
                'name' => 'PureeSense Vitamin C & Papaya Brightening Sheet Mask | For Glowing, Nourished & Deeply Hydrated Skin | For Dry, Oily and Combination Skin | From the makers of Parachute Advansed',
                'slug' => 'pureesense-vitamin-c-papaya-brightening-sheet-mask-for-glowing-nourished-deeply-hydrated-skin-for-dry-oily-and-combination-skin-from-the-makers-of-parachute-advansed-keyoy',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Vitamin C &amp; Niacinamide : Know to have multiple benefits, these two when combined, give your skin a glow from within!</span></p><p><span style="color: rgb(0, 0, 0);">-Papaya : Papaya contains natural bleaching properties and its application is known to lighten your skin over a period of time</span></p><p><span style="color: rgb(0, 0, 0);">-Thanaka : Thanaka is a rich source of Vitamin E, that protects your skin against pollution.</span></p><p><span style="color: rgb(0, 0, 0);">-Bengkoang : Bengkoang contains Vitamin C and B1, which work together to deeply nourish your skin, making your skin glow and appear healthy.</span></p><p><span style="color: rgb(0, 0, 0);">-Travel friendly : this product is easy to use and travel-friendly. This Pure pick is suitable for all skin types.</span></p>',
                'brand_id' => 1,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 22.0,
                'max_price' => 22.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/puresense_vitamin_c_2.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:27:07',
                'updated_at' => '2023-09-26 10:27:07',
                'deleted_at' => null,
            ],
            18 => [
                'id' => 19,
                'name' => 'O2+ Whitening Facial Kit for Tan-Pigmented Skin Radiance & Shine',
                'slug' => 'o2-whitening-facial-kit-for-tan-pigmented-skin-radiance-shine-seqxc',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Concern whitening, pigmentation control skin type normal to dry, all skin type benefits increased fairness and pigmentation control details. The O2+ whitening kit suitable for normal to dry skin comprises of whitening cleansing foam, whitening tonic, whitening serum, whitening cream and whitening mask.</span></p>',
                'brand_id' => 3,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 120.0,
                'max_price' => 120.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/skincare_products/o3_whitening_facial_kit_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:29:13',
                'updated_at' => '2023-09-26 10:29:13',
                'deleted_at' => null,
            ],
            19 => [
                'id' => 20,
                'name' => 'Bluue Heaven Bling Nail Paint - Boss Babe',
                'slug' => 'bluue-heaven-bling-nail-paint-boss-babe-y3akn',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Highly pigmented nail polish with a creme-gloss finish</span></p><p><span style="color: rgb(0, 0, 0);">-Provides excellent coverage and shine in just one application</span></p><p><span style="color: rgb(0, 0, 0);">-Features a quick-drying, chip-resistant, and long-lasting formula</span></p><p><span style="color: rgb(0, 0, 0);">-Easy-to-apply fan-shaped brush applicator ensures a smooth and perfect finish</span></p><p><span style="color: rgb(0, 0, 0);">-It delivers an excellent and even color payoff</span></p><p><span style="color: rgb(0, 0, 0);">-Evenly suspends the high-shine color on your nails</span></p><p><span style="color: rgb(0, 0, 0);">-Comes in a range of new shades inspired by the latest trends</span></p><p><span style="color: rgb(0, 0, 0);">-This product is cruelty-free</span></p>',
                'brand_id' => 6,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 70.0,
                'max_price' => 70.0,
                'discount_value' => 3.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1693526400,
                'discount_end_date' => 1696032000,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/blue_heaven_bling_nail_paint_boss_babe_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:32:01',
                'updated_at' => '2023-09-26 10:32:01',
                'deleted_at' => null,
            ],
            20 => [
                'id' => 21,
                'name' => 'Nykaaa Insta Dry Fast Drying Nail Enamel Polish Sky Share 354 - Light Blue',
                'slug' => 'nykaaa-insta-dry-fast-drying-nail-enamel-polish-sky-share-354-light-blue-jay6o',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">No more waiting around for your nails to dry after a manicure. Get super glossy nails in about a minute with the Nykaa Insta Dry Nail Enamel collection that comes in an impressive range of colours. Glide on a coat of the Insta Dry enamel for a flawless coverage, that won\'t chip, fade or smudge.It\'s tried and tested!</span></p>',
                'brand_id' => 6,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1695686400,
                'discount_end_date' => 1695686400,
                'sell_target' => null,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 0,
                'max_purchase_qty' => 0,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 0,
                'express_delivery_hours' => 0,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/nykaa_insta_dry_fast_drying_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:34:21',
                'updated_at' => '2023-09-26 10:53:56',
                'deleted_at' => null,
            ],
            21 => [
                'id' => 22,
                'name' => 'Nail Art Kit - 48 Pcs Glass Bottles Glitter Stones, 100 Nails,10 Nail Tapes, 15 Nail Art brush, 5 Nail Dotting Pen with 2 Glue (Nail Art Kit)',
                'slug' => 'nail-art-kit-48-pcs-glass-bottles-glitter-stones-100-nails10-nail-tapes-15-nail-art-brush-5-nail-dotting-pen-with-2-glue-nail-art-kit-twuud',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Double-ended nail dotting pens: each is end with a large ball and another end with a small ball for various size dotting</span></p><p><span style="color: rgb(0, 0, 0);">-Multicolored nail striping tape: 10 pieces assorted colors can be used to design your own nail art nail patterns, highlight, etc. meeting your diversified needs, easy to paste in free form</span></p><p><span style="color: rgb(0, 0, 0);">-Fantastic professional nail art set: Contain 15pcs nail art design brush set, 5pcs nail art 2-way drawing dotting painting pen,10pcs assorted colors nail striping tape, meets all you need for perfect nail art.</span></p><p><span style="color: rgb(0, 0, 0);">-A great little gift ideas gifts for friends who like to do nail art.</span></p><p><span style="color: rgb(0, 0, 0);">-Create Your Unique Nail Art Design.</span></p>',
                'brand_id' => 6,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 80.0,
                'discount_value' => 5.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1695081600,
                'discount_end_date' => 1695859200,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/urbanmac_nail_art_kit_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:36:29',
                'updated_at' => '2023-09-26 10:36:29',
                'deleted_at' => null,
            ],
            22 => [
                'id' => 23,
                'name' => 'Panaache Nail Pre-Color Application Kit',
                'slug' => 'panaache-nail-pre-color-application-kit-0kxky',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Get ready for the perfect nail colour application with Panache Nail Pre-Color Application Kit.</span></p><p><span style="color: rgb(0, 0, 0);">-It includes Nail Clipper anti- skid with an anti-skid grip that prevents slipping, Nail Polish Remover Pads removes nail polish quickly without the mess associated with bottle, pair of Toe Separator and Finger Separator to avoid polish smudge.</span></p><p><span style="color: rgb(0, 0, 0);">-For personal and professional use.</span></p><p><span style="color: rgb(0, 0, 0);">-Expect a sleek finish</span></p><p><span style="color: rgb(0, 0, 0);">-Anti-skid property ensures no slipping.</span></p><p><br></p>',
                'brand_id' => 5,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 42.0,
                'max_price' => 42.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/panache_nail_pre_color_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:38:50',
                'updated_at' => '2023-09-26 10:38:50',
                'deleted_at' => null,
            ],
            23 => [
                'id' => 24,
                'name' => 'Majjestique 2 In 1 Plate Foot Scrubber & Emery Board Nail Filer - Color May Vary',
                'slug' => 'majjestique-2-in-1-plate-foot-scrubber-emery-board-nail-filer-color-may-vary-qwela',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Introducing the Majestique 2-in-1 Plate Foot Scrubber and Emery Board Nail Filer - the perfect pedicure and manicure kit for clean and healthy feet and nails. This set includes two pieces in attractive multicolor that are sure to add a touch of style to any bathroom.</span></p><p><span style="color: rgb(0, 0, 0);">-The unique plate foot scrubber is designed to gently scrub away dirt and grime from the soles of your feet while the Emery Board Nail Filer is perfect for filing and shaping your nails. The scrubber is made from durable plastic and features non-slip rubberized feet for extra stability.</span></p><p><span style="color: rgb(0, 0, 0);">-The Emery Board is made from high-quality emery paper for a smooth finish. Whether you’re looking for a luxurious pedicure or a quick and easy manicure, the Majestique 2-in-1 Plate Foot Scrubber and Emery Board Nail Filer are the perfect tools for the job.</span></p>',
                'brand_id' => 11,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 59.0,
                'max_price' => 59.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/majestique_2_in_1_plate_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:41:33',
                'updated_at' => '2023-09-26 10:41:33',
                'deleted_at' => null,
            ],
            24 => [
                'id' => 25,
                'name' => 'Bronson Professional Nail Filer And Cuticle Trimmer',
                'slug' => 'bronson-professional-nail-filer-and-cuticle-trimmer-w8wxh',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Bronson Professional combines two functions in one that provides complete nail care. This essential nail filer has a two-sided nickel plated surface for smooth, gentle filling of nails while the cuticle trimmer trims the dead skin along the nails with outward strokes, making your cuticles and nails looking good.</span></p><p><span style="color: rgb(0, 0, 0);">-Nail Files :- buffer to smooth, a stainless steel file to shape and a metal cuticle trimmer.Nail file made from high quality stainless steel and emery board.Deigned with double-end, one end is nail Exfoliating cutter ,another is nail file to shape your nail more smooth,provides you a comfortable nail doing</span></p><p><span style="color: rgb(0, 0, 0);">-Nail Shape Organizer :- Nail art files work quickly to trim or shape the acrylic nail with your desires shape or length.Perfect to remove nail gel in your extended or fake nails.Will not damage your nail or acrylic nail ,make sure your finger toe nail smoothly in doing.</span></p>',
                'brand_id' => 2,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 32.0,
                'max_price' => 32.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/bronson_professional_nail_filer_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:43:07',
                'updated_at' => '2023-09-26 10:43:07',
                'deleted_at' => null,
            ],
            25 => [
                'id' => 26,
                'name' => 'Vaadee Herbal Nail & Cuticle Oil with Jojoba Oil',
                'slug' => 'vaadee-herbal-nail-cuticle-oil-with-jojoba-oil-fws50',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-An Excellent way to moisturise and condition the nails and cuticle area. It mainly strengthens thin, weak nails by treating damaged cuticles at the root. It also prevents cracking and peeling of cuticles, making them smooth and nourished.</span></p><p><span style="color: rgb(0, 0, 0);">*Why Use Cuticle Oil?</span></p><p><span style="color: rgb(0, 0, 0);">-Cuticle oil is used to moisturize the cuticle, skin and nail area. It can protect the cuticle and nail against damage and improve the health and appearance of the cuticles and nails. Cuticle oil should not be used as a first-line of defense against dryness, but rather to fix extremely dry, cracked nails. Made of natural, rapidly absorbing vegetable oils, cuticle oil can also contain vitamins and citric acid.</span></p>',
                'brand_id' => 5,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 45.0,
                'max_price' => 45.0,
                'discount_value' => 5.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1696118400,
                'discount_end_date' => 1698710400,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/vaadi_herbal_nail_cuticle_oil_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:46:16',
                'updated_at' => '2023-09-26 10:46:16',
                'deleted_at' => null,
            ],
            26 => [
                'id' => 27,
                'name' => 'L\'Occeetane Shea Butter Nail & Cuticle Nourishing Oil',
                'slug' => 'locceetane-shea-butter-nail-cuticle-nourishing-oil-zokup',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Feel nourished up to your fingertips. Enriched with a high concentration of shea oil (30%), the Nail &amp; Cuticule Nourishing Oil soften your cuticles and strengthen your nails, nourishing every nook and cranny of them. It comes with a brush applicator for a quick and easy application. Be ready to have gorgeous nails !</span></p><p><span style="color: rgb(0, 0, 0);">*Vegan friendly:</span></p><p><span style="color: rgb(0, 0, 0);">-99% natural origin ingredients</span></p><p><span style="color: rgb(0, 0, 0);">-97% readily biodegradable ingredients</span></p><p><span style="color: rgb(0, 0, 0);">*Proven results:</span></p><p><span style="color: rgb(0, 0, 0);">-100% Immediately after use, nails seem more beautiful</span></p><p><span style="color: rgb(0, 0, 0);">-96% Cuticles seem intensely nourished</span></p><p><span style="color: rgb(0, 0, 0);">-96% Cuticles look suppler</span></p>',
                'brand_id' => 11,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 25.0,
                'max_price' => 40.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 15,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/loccitane_shea_butter_nail_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:48:32',
                'updated_at' => '2023-09-26 10:48:32',
                'deleted_at' => null,
            ],
            27 => [
                'id' => 28,
                'name' => 'Buttter London Jelly Preserve Nail Strengthener - Victoria Plum',
                'slug' => 'buttter-london-jelly-preserve-nail-strengthener-victoria-plum-tcbq3',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Give dry, brittle nails a much-needed break from polish, gel and acrylics and give your manicure the skin-loving, skincare benefits of this bestselling Jelly Preserve Sheer Strengthening Nail Treatment.</span></p><p><span style="color: rgb(0, 0, 0);">-The revolutionary 2-in 1 translucent nail colour and 10-Free nail treatment formula gives the effect of a delicious sheer jelly look while working hard to rejuvenate the look of nails and helping to repair damage from harsh nail formulas and practices.</span></p>',
                'brand_id' => 5,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 55.0,
                'max_price' => 55.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/butter_london_jelly_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:50:31',
                'updated_at' => '2023-09-26 10:50:31',
                'deleted_at' => null,
            ],
            28 => [
                'id' => 29,
                'name' => 'Nykaaa Nail Care - Get Even Ridge Filler',
                'slug' => 'nykaaa-nail-care-get-even-ridge-filler-j9lvo',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*Nykaa 7-in-1 Nail Spa</span></p><p><span style="color: rgb(0, 0, 0);">-It is enriched with actives for stronger, smoother and shinier nails. This mircalous formula reinforces soft, weak, bitten or thin nails. Your nails look naturally healthy and rejuvenated!</span></p><p><span style="color: rgb(0, 0, 0);">-Contains Acetyl-Methionine and Keratin-like Peptide that together add to the natural keratin to your nails to prevent them from breakage</span></p><p><span style="color: rgb(0, 0, 0);">-Includes Hexanal: Powerful, patented aldehyde that hardens and improves the condition of the nails</span></p><p><span style="color: rgb(0, 0, 0);">-Features Amino Acids that stimulate the nail growth</span></p><p><span style="color: rgb(0, 0, 0);">-Has Vitamin E and Violet extract for hydration, antioxidant and protective power</span></p><p><span style="color: rgb(0, 0, 0);">-Blend of Argan, Baobab Oils for nourishing property.</span></p>',
                'brand_id' => 6,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 45.0,
                'max_price' => 45.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 40,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/nykaa_nail_care_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:52:50',
                'updated_at' => '2023-09-26 10:52:50',
                'deleted_at' => null,
            ],
            29 => [
                'id' => 30,
                'name' => 'Pluum Color Affair 3-in-1 Strengthener, Base & Top Coat',
                'slug' => 'pluum-color-affair-3-in-1-strengthener-base-top-coat-a166m',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Plum Color Affair 3-in-1 Strengthener, Base &amp; Top Coat</span></p><p><span style="color: rgb(0, 0, 0);">-Benefits</span></p><p><span style="color: rgb(0, 0, 0);">*Strength *Hardening *Protection *Smoothing Hydration *NutritionShine</span></p>',
                'brand_id' => 7,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 15.0,
                'max_price' => 32.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/nail_care_products/plum_color_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 10:57:31',
                'updated_at' => '2023-09-26 10:57:31',
                'deleted_at' => null,
            ],
            30 => [
                'id' => 31,
                'name' => 'Sweess Beauty Pure Matte Lipstick - 206 Coral Red',
                'slug' => 'sweess-beauty-pure-matte-lipstick-206-coral-red-ikysi',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Swiss Beauty presents a transfer-proof, creamy lipstick to complement every makeup look. This lipstick is formulated to give your lips a plush, soft feel and a single application lasts all day.</span></p><p><span style="color: rgb(0, 0, 0);">-It has intense pigments that help provide the colour that lasts all day long. It\'s moisturizingly matte for your lips comfort.</span></p>',
                'brand_id' => 8,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/swiss_beauty_lipstick_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:01:20',
                'updated_at' => '2023-09-26 11:01:20',
                'deleted_at' => null,
            ],
            31 => [
                'id' => 32,
                'name' => 'Nykaaa So Matte! Mini Lipstick - 11 Naughty Nude',
                'slug' => 'nykaaa-so-matte-mini-lipstick-11-naughty-nude-odkbo',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Give a radiant touch to your whole look with Nykaa\'s So Matte!Mini Lipstick collection. Experience the same plush, pigment rich formula in Mini Version so it becomes a staple in your bag! The formulation delivers flawless coverage and assures precise application for a perfectly contoured pout. The creamy formula gives your lips a great matte finish. So up the ante with a sophisticated finishing touch to set off those glamorous evenings!</span></p><p><span style="color: rgb(0, 0, 0);">-Smooth texture!</span></p><p><span style="color: rgb(0, 0, 0);">-One stroke application</span></p><p><span style="color: rgb(0, 0, 0);">-Subtle shades to enhance your natural lip colour.</span></p><p><span style="color: rgb(0, 0, 0);">*Why should you make it yours?</span></p><p><span style="color: rgb(0, 0, 0);">-The moisture rich Vitamin E extract assures soft, healthy, natural lip shade to ensure your lips stays matte-smooth all day. The creamy texture gives a smooth consistency to your lips. So Make these super affordable lip shades yours and rave about shades all day!</span></p>',
                'brand_id' => 6,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/nykaa_so_matte_mini_lipstick_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:06:06',
                'updated_at' => '2023-09-26 11:06:06',
                'deleted_at' => null,
            ],
            32 => [
                'id' => 33,
                'name' => 'Lekme Absolute Matte Melt Mini Liquid Lip Color - Indie Maroon',
                'slug' => 'lekme-absolute-matte-melt-mini-liquid-lip-color-indie-maroon-jfhuv',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Game, Set, Matte! Fall mattely in love with our Nykaa Matteilicious Crayons. These lip crayons boasts a remarkable formula that pushes the boundaries of color intensity with an extreme matte formula. This supreme formula glides on your lips effortlessly giving you that matte finish that you’ve always craved for!</span></p><p><span style="color: rgb(0, 0, 0);">-Made In Europe</span></p><p><span style="color: rgb(0, 0, 0);">-Paraben Free</span></p><p><span style="color: rgb(0, 0, 0);">-Extreme matte finish</span></p><p><span style="color: rgb(0, 0, 0);">-No feathering</span></p><p><span style="color: rgb(0, 0, 0);">-One stroke application</span></p>',
                'brand_id' => 9,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 60.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/lakme_absolute_matte_melt_mini_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:08:30',
                'updated_at' => '2023-09-26 11:08:30',
                'deleted_at' => null,
            ],
            33 => [
                'id' => 34,
                'name' => 'Nykaaa Eyes On Me! 10-in-1 Eyeshadow Palette - Sundowner Stunner',
                'slug' => 'nykaaa-eyes-on-me-10-in-1-eyeshadow-palette-sundowner-stunner-x04k0',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Nykaa Eyes On Me! 10-in-1 Eyeshadow Palette - Sundowner Stunner</span></p><p><span style="color: rgb(0, 0, 0);">*Top Features</span></p><p><span style="color: rgb(0, 0, 0);">-Complementary Shades To Create</span></p><p><span style="color: rgb(0, 0, 0);">-Versatile Looks</span></p><p><span style="color: rgb(0, 0, 0);">-High Pigment Properties</span></p><p><span style="color: rgb(0, 0, 0);">-10 Hour Wear</span></p><p><span style="color: rgb(0, 0, 0);">-Easy To Blend</span></p>',
                'brand_id' => 6,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 35.0,
                'max_price' => 45.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/nykaa_eyes_on_me_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:18:50',
                'updated_at' => '2023-09-26 11:18:50',
                'deleted_at' => null,
            ],
            34 => [
                'id' => 35,
                'name' => 'Makeup Revolution Maxi Reloaded Palette - Large It Up',
                'slug' => 'makeup-revolution-maxi-reloaded-palette-large-it-up-80xdf',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Listen up, the Revolution Maxi Reloaded Baby Grand is going to seriously up your makeup game. With a selection of powerful matte, shimmer and pressed glitter shades in a variety of mauve, lilac and purple shaded; you\'ll want to try out all 45 hues! The pigments are mixed with metallic glitters that, when added to matte shades, will add instant glam.</span></p><p><span style="color: rgb(0, 0, 0);">-Use the beige and warm brown shades as a base, apply different tones of purple to the lids and use a thin eyeshadow brush to create a killer cut crease with the pops of fuchsia. Finish by highlighting with metallic copper, gold and pink glitter. Don\'t forget to show us your looks on Insta, we want to see the best poppin\' purple eyes!</span></p>',
                'brand_id' => 9,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 80.0,
                'discount_value' => 5.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1696464000,
                'discount_end_date' => 1697587200,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/makeup_revolution_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:21:30',
                'updated_at' => '2023-09-26 11:21:30',
                'deleted_at' => null,
            ],
            35 => [
                'id' => 36,
                'name' => 'Feces Caanada 3 In 1 All Day Hydra Matte Foundation - Absolute Ivory 012',
                'slug' => 'feces-caanada-3-in-1-all-day-hydra-matte-foundation-absolute-ivory-012-oudxt',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Blends easily</span></p><p><span style="color: rgb(0, 0, 0);">-Long stay</span></p><p><span style="color: rgb(0, 0, 0);">-Medium to high coverage</span></p><p><span style="color: rgb(0, 0, 0);">*Enriched with:</span></p><p><span style="color: rgb(0, 0, 0);">-Vitamin c for brighter looking skin</span></p><p><span style="color: rgb(0, 0, 0);">-Aloe vera for all day hydration</span></p>',
                'brand_id' => 3,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 30.0,
                'max_price' => 55.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 15,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/faces_canada_3_in_1_all_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:23:39',
                'updated_at' => '2023-09-26 11:23:39',
                'deleted_at' => null,
            ],
            36 => [
                'id' => 37,
                'name' => 'MyyGlamm Super Serum Foundation SPF 30 - 302W Wheat',
                'slug' => 'myyglamm-super-serum-foundation-spf-30-302w-wheat-e1yus',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Cleanse and prep your face. Pump out a coin-sized amount</span></p><p><span style="color: rgb(0, 0, 0);">-Dot all over your face and neck. Blend evenly for seamless coverage</span></p><p><span style="color: rgb(0, 0, 0);">-Touch up with MyGlamm Super Serum Compact . throughout the day for transfer-resistant wear.</span></p>',
                'brand_id' => 11,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 20.0,
                'max_price' => 40.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/myglamm_super_serum_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:29:03',
                'updated_at' => '2023-09-26 11:29:03',
                'deleted_at' => null,
            ],
            37 => [
                'id' => 38,
                'name' => 'Majjestique Mushroom Head Sponge With Handle Case, Powder Puff For Dual-Use Dry & Wet- Color May Vary',
                'slug' => 'majjestique-mushroom-head-sponge-with-handle-case-powder-puff-for-dual-use-dry-wet-color-may-vary-k1l5a',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*Key Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Cleansing makeup sponge helps to apply and remove makeup</span></p><p><span style="color: rgb(0, 0, 0);">-Made from a soft, porous material that absorbs and distributes makeup and other products evenly over the skin</span></p><p><span style="color: rgb(0, 0, 0);">-Soft and gentle material that is gentle on the skin</span></p><p><span style="color: rgb(0, 0, 0);">-Provides a flawless, natural-looking finish</span></p><p><span style="color: rgb(0, 0, 0);">-Perfect for daily makeup or for a professional makeup artist</span></p><p><span style="color: rgb(0, 0, 0);">*Benefits</span></p><p><span style="color: rgb(0, 0, 0);">-Cleansing makeup sponges are a great way to apply and remove makeup.</span></p><p><span style="color: rgb(0, 0, 0);">-They are usually made from a soft, porous material that absorbs and distributes makeup and other products evenly over the skin.</span></p>',
                'brand_id' => 12,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 42.0,
                'max_price' => 42.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/majestique_mushroom_head_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:30:47',
                'updated_at' => '2023-09-26 11:30:47',
                'deleted_at' => null,
            ],
            38 => [
                'id' => 39,
                'name' => 'Sweess Beauty Professional Makeup Brush Sets(12 pcs)',
                'slug' => 'sweess-beauty-professional-makeup-brush-sets12-pcs-c0dtf',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Swiss Beauty Professional Makeup Brush Set is a complete set of professional makeup brushes for the professional artist in you. It consists of 12 makeup brush sets.</span></p><p><span style="color: rgb(0, 0, 0);">-It\'s convenient for travelling and setup. Featuring a wide range of brushes to amplify vibrant style in you. the fine brush set range can be used with - Compact powder, foundation, blusher, contouring, eyeshadow application, eyeshadow blending, liner, angular, lipstick, mascara and eyebrow grooming.</span></p>',
                'brand_id' => 8,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 35.0,
                'max_price' => 35.0,
                'discount_value' => 5.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1696118400,
                'discount_end_date' => 1698710400,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/swiss_beauty_makeup_brush_sets_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:32:20',
                'updated_at' => '2023-09-26 11:32:20',
                'deleted_at' => null,
            ],
            39 => [
                'id' => 40,
                'name' => 'Beautiliss Makeup Brush Set With Faux Leather Bag - 7 Pcs',
                'slug' => 'beautiliss-makeup-brush-set-with-faux-leather-bag-7-pcs-dw1ml',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">This kit includes:</span></p><p><span style="color: rgb(0, 0, 0);">-Powder Brush: Allows for perfect application of face powders to achieve a natural-looking appearance.</span></p><p><span style="color: rgb(0, 0, 0);">-Blending Brush: This densely packed bristle brush works well with both creamy and powder/baked eye shadows.</span></p><p><span style="color: rgb(0, 0, 0);">-Large Eyeshadow Brush: Densely packed bristle brush works well with both creamy and powder/baked eye shadows, ideal for blending transition shades.</span></p><p><span style="color: rgb(0, 0, 0);">-Small Eyeshadow Brush: Densely packed bristle brush works well with both creamy and powder/baked eye shadow, ideal for applying glitter or adding pop of colour to the lids.</span></p><p><span style="color: rgb(0, 0, 0);">-Eyebrow Brush: An angled brush made from super soft, cruelty-free bristles ideal for precise eyebrow filling and defining.</span></p><p><span style="color: rgb(0, 0, 0);">-Eyebrow Spoolie: Helps define and brush brow hair for a defined look.</span></p><p><span style="color: rgb(0, 0, 0);">-Lip Brush: Line and fill your lips perfectly with this precise brush.</span></p>',
                'brand_id' => 8,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 42.0,
                'max_price' => 42.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/beautiliss_makeup_brush_set_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:33:41',
                'updated_at' => '2023-09-26 11:33:41',
                'deleted_at' => null,
            ],
            40 => [
                'id' => 41,
                'name' => 'Bronnson Professional Eyebrow and Face Razor - Pack of 3',
                'slug' => 'bronnson-professional-eyebrow-and-face-razor-pack-of-3-jrzvi',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Benefit:</span></p><p><span style="color: rgb(0, 0, 0);">-Cleansing makeup sponges are a great way to apply and remove makeup.</span></p><p><span style="color: rgb(0, 0, 0);">-They are usually made from a soft, porous material that absorbs and distributes makeup and other products evenly over the skin.</span></p><p><span style="color: rgb(0, 0, 0);">-Soft and gentle material that is gentle on the skin.</span></p><p><span style="color: rgb(0, 0, 0);">-Absorbs and distributes makeup and other products evenly over the skin.</span></p>',
                'brand_id' => 8,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 38.0,
                'max_price' => 38.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/bronson_professional_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:35:50',
                'updated_at' => '2023-09-26 11:35:50',
                'deleted_at' => null,
            ],
            41 => [
                'id' => 42,
                'name' => 'Majjestique Glitter Round Makeup Mirror 1X/2X Magnifying',
                'slug' => 'majjestique-glitter-round-makeup-mirror-1x2x-magnifying-bsaqs',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Compact and portable: The round shape and small size of the makeup mirror makes it easy to carry and store.</span></p><p><span style="color: rgb(0, 0, 0);">-Magnifying mirror: The makeup mirror provides up to 2x magnification, allowing you to get a closer look and detail when applying makeup.</span></p><p><span style="color: rgb(0, 0, 0);">-Durable and sturdy: The makeup mirror is made from high-quality materials, making it strong and durable.</span></p><p><span style="color: rgb(0, 0, 0);">-Adjustable stand: The makeup mirror features an adjustable stand that allows you to adjust the angle for a better view.</span></p><p><span style="color: rgb(0, 0, 0);">*Benefits</span></p><p><span style="color: rgb(0, 0, 0);">-Compact and Portable: The round shape and small size of the makeup mirror makes it easy to carry and store.</span></p><p><span style="color: rgb(0, 0, 0);">-Magnifying Mirror: The makeup mirror provides up to 2x magnification, allowing you to get a closer look and detail when applying makeup.</span></p>',
                'brand_id' => 12,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/majestique_glitter_round_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:37:23',
                'updated_at' => '2023-09-26 11:37:23',
                'deleted_at' => null,
            ],
            42 => [
                'id' => 43,
                'name' => 'GUUBB Beauty Surprise Kit, 4 Brushes, Beauty Blender and Eyelash Curler',
                'slug' => 'guubb-beauty-surprise-kit-4-brushes-beauty-blender-and-eyelash-curler-4m1o5',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Beauty Favourites</span></p><p><span style="color: rgb(0, 0, 0);">-4 Makeup Brushes,</span></p><p><span style="color: rgb(0, 0, 0);">-1 Eyelash Curler (Rose Gold)</span></p><p><span style="color: rgb(0, 0, 0);">-1 Beauty Blender</span></p><p><span style="color: rgb(0, 0, 0);">A Must-Have For Any Makeup Lover!</span></p>',
                'brand_id' => 4,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 40.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/beauty_and_makeup_products/gubb_beauty_surprise_kit_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:39:23',
                'updated_at' => '2023-09-26 11:39:23',
                'deleted_at' => null,
            ],
            43 => [
                'id' => 44,
                'name' => 'Feeama Radiant Glow Blackcurrant & Bearberry Shower Gel',
                'slug' => 'feeama-radiant-glow-blackcurrant-bearberry-shower-gel-dnbpy',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Soothe and relax your skin with Fiama Di Wills Shower Gel.</span></p><p><span style="color: rgb(0, 0, 0);">-Enriched with Conditioner and Moisture Lock it helps to retain moisture of the skin to make it softer, smoother and supple.</span></p><p><span style="color: rgb(0, 0, 0);">-The soft, buttery gel lathers well on the skin and eradicates all impurities to make it clean and clear.</span></p><p><span style="color: rgb(0, 0, 0);">-It contains Blackcurrant and Bearberry extracts which pampers your skin and gives youthful glow.</span></p><p><span style="color: rgb(0, 0, 0);">-Lucisous fragrance stays with you for long time.</span></p>',
                'brand_id' => 13,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 60.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/fiama_radiant_glow_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:42:54',
                'updated_at' => '2023-09-26 11:42:54',
                'deleted_at' => null,
            ],
            44 => [
                'id' => 45,
                'name' => '"Feeama Lavender & Vit C + Rose & Aloevera Shim Body Wash Combo (2 pcs)"',
                'slug' => 'feeama-lavender-vit-c-rose-aloevera-shim-body-wash-combo-2-pcs-5rpwz',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Mesmerising fragrance that transports you to a tranquil place of peace and calm with an aromatic blend of Bergamot, Rosemary &amp; Geranium</span></p><p><span style="color: rgb(0, 0, 0);">-100% Natural origin</span></p><p><span style="color: rgb(0, 0, 0);">-100% Natural himalayan oil</span></p><p><span style="color: rgb(0, 0, 0);">-Plant based cleanser</span></p><p><span style="color: rgb(0, 0, 0);">-Mild &amp; gentle</span></p><p><span style="color: rgb(0, 0, 0);">-Soap free</span></p><p><span style="color: rgb(0, 0, 0);">-100% Recyclable packaging</span></p>',
                'brand_id' => 13,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 55.0,
                'max_price' => 55.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/lux_lavender_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 11:59:03',
                'updated_at' => '2023-09-26 11:59:03',
                'deleted_at' => null,
            ],
            45 => [
                'id' => 46,
                'name' => 'mCaaffeine Epsom Bath Salt with Therapeutic Coffee Vanilla Fragrance - Detoxifies & Relieves Stress',
                'slug' => 'mcaaffeine-epsom-bath-salt-with-therapeutic-coffee-vanilla-fragrance-detoxifies-relieves-stress-crkxx',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*SALT N\' COFFEE TO</span></p><p><span style="color: rgb(0, 0, 0);">-Relax &amp; De-Stress</span></p><p><span style="color: rgb(0, 0, 0);">-Relaxes &amp; De-stresses</span></p><p><span style="color: rgb(0, 0, 0);">-Relieves Pain</span></p><p><span style="color: rgb(0, 0, 0);">-Soothing Coffee-Vanilla</span></p><p><span style="color: rgb(0, 0, 0);">-Fragrance</span></p><p><span style="color: rgb(0, 0, 0);">*How to use it?</span></p><p><span style="color: rgb(0, 0, 0);">-Step 1: Add 2 spoons of Coffee Bath Salt to warm water.</span></p><p><span style="color: rgb(0, 0, 0);">-Step 2: Soak in and relax for at least 15-20 minutes.</span></p><p><span style="color: rgb(0, 0, 0);">-Step 3: Take a quick shower and come out refreshed.</span></p>',
                'brand_id' => 4,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 100.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/mcaffeine_epsom_bath_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:01:24',
                'updated_at' => '2023-09-26 12:01:24',
                'deleted_at' => null,
            ],
            46 => [
                'id' => 47,
                'name' => 'BLIISCENT Orange & Lime Bath and Foot Soak',
                'slug' => 'bliiscent-orange-lime-bath-and-foot-soak-95yrr',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">-The Bliscent Orange &amp; Lime Foot Soak is a zesty and refreshing blend of salts and essential oils that eliminates toxins and dead skin from the feet. The uplifting scent of Orange and Lime will soothe your sense and make you feel relaxed.</span></p><p><span style="color: rgb(0, 0, 0);">*Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Natural detox for the feet</span></p><p><span style="color: rgb(0, 0, 0);">-Helps ease muscle tension and pain</span></p><p><span style="color: rgb(0, 0, 0);">-Eliminates toxins and softens rough skin</span></p><p><span style="color: rgb(0, 0, 0);">-All products are SLS and Paraben free</span></p><p><span style="color: rgb(0, 0, 0);">-100% Vegan and cruelty free</span> </p>',
                'brand_id' => 13,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 78.0,
                'max_price' => 78.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/bliscent_orange_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:03:03',
                'updated_at' => '2023-09-26 12:03:03',
                'deleted_at' => null,
            ],
            47 => [
                'id' => 48,
                'name' => 'mCaaffeine Body Polishing Kit - Exfoliation, Tan Removal & Moisturization - Coffee Body Scrub & Choco Body Butter',
                'slug' => 'mcaaffeine-body-polishing-kit-exfoliation-tan-removal-moisturization-coffee-body-scrub-choco-body-butter-twhjo',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*How to Use</span></p><p><span style="color: rgb(0, 0, 0);">-Apply body scrub on wet body.</span></p><p><span style="color: rgb(0, 0, 0);">-Massage in circular motions.</span></p><p><span style="color: rgb(0, 0, 0);">-Rinse &amp; pat dry.</span></p><p><span style="color: rgb(0, 0, 0);">-Follow up with application of body butter.</span></p><p><span style="color: rgb(0, 0, 0);">*The Good We Are</span></p><p><span style="color: rgb(0, 0, 0);">-PETA Certified Vegan</span></p><p><span style="color: rgb(0, 0, 0);">-Made Safe</span></p><p><span style="color: rgb(0, 0, 0);">-FDA-approved</span></p><p><span style="color: rgb(0, 0, 0);">-Dermatologically-tested</span></p><p><span style="color: rgb(0, 0, 0);">-Gender-neutral</span></p><p><span style="color: rgb(0, 0, 0);">-Inclusive</span></p><p><span style="color: rgb(0, 0, 0);">*The Bad We Beat</span></p><p><span style="color: rgb(0, 0, 0);">-Testing on Animals</span></p><p><span style="color: rgb(0, 0, 0);">-Parabens in formulation</span></p><p><span style="color: rgb(0, 0, 0);">-SLS in products</span></p>',
                'brand_id' => 4,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 58.0,
                'max_price' => 58.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/mcaffeine_body_polishing_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:04:57',
                'updated_at' => '2023-09-26 12:04:57',
                'deleted_at' => null,
            ],
            48 => [
                'id' => 49,
                'name' => 'Chemistt at Play Underarm Roll On Controls Odour -5% AHA- Aqua Fragrance',
                'slug' => 'chemistt-at-play-underarm-roll-on-controls-odour-5-aha-aqua-fragrance-y7ehh',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*What Does it Do?</span></p><p><span style="color: rgb(0, 0, 0);">Exfoliates and Refreshes:</span></p><p><span style="color: rgb(0, 0, 0);">-Controls odour by removing smelly bacteria</span></p><p><span style="color: rgb(0, 0, 0);">-Is not sticky or icky</span></p><p><span style="color: rgb(0, 0, 0);">-No Patches on your clothes</span></p><p><span style="color: rgb(0, 0, 0);">-Helps even the skin tone</span></p><p><span style="color: rgb(0, 0, 0);">*Ingredients:</span></p><p><span style="color: rgb(0, 0, 0);">-4% Lactic Acid: Eliminates dead skin cells</span></p><p><span style="color: rgb(0, 0, 0);">-1 Mandelic Acid:</span></p><p><span style="color: rgb(0, 0, 0);">*Reduces dark spots and evens out skin tone</span></p>',
                'brand_id' => 7,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 55.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 0,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/chemist_at_play_underarm_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:06:59',
                'updated_at' => '2023-09-26 12:06:59',
                'deleted_at' => null,
            ],
            49 => [
                'id' => 50,
                'name' => 'Jaguaar Body Spray Deodorant Spray - For Men',
                'slug' => 'jaguaar-body-spray-deodorant-spray-for-men-sixba',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-The legendary fragrance composition: a citrus-herbal fragrance reflecting the classic image of Jaguaar. A harmony of bergamot, grapefruit, tangerine and orange evokes a note of freshness as a touch of gardenia gives it an accent.</span></p><p><span style="color: rgb(0, 0, 0);">-Sensuality comes from its "heart" with nutmeg and cloves, while sandalwood, pine and cedar mix with patchouli for mysterious overtones. All based on masculine notes of amber, tobacco and leather.</span></p>',
                'brand_id' => 7,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/jaguar_body_spray_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:08:45',
                'updated_at' => '2023-09-26 12:08:45',
                'deleted_at' => null,
            ],
            50 => [
                'id' => 51,
                'name' => 'Adiddas Ice Dive Edt Spray',
                'slug' => 'adiddas-ice-dive-edt-spray-xtdil',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-It is recommended for daily wear</span></p><p><span style="color: rgb(0, 0, 0);">-The composition is built of a perfect harmony of sweet and salty notes of sea water and nuances of sunny warmth on your skin</span></p><p><span style="color: rgb(0, 0, 0);">-This is high quality product made of high quality material</span></p><p><span style="color: rgb(0, 0, 0);">-Packaging for this product may vary from that shown in the image above</span></p><p><span style="color: rgb(0, 0, 0);">-This item is not for sale in Catalina Island</span></p>',
                'brand_id' => 14,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/adidas_ice_dive_edt_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:10:22',
                'updated_at' => '2023-09-26 12:10:22',
                'deleted_at' => null,
            ],
            51 => [
                'id' => 52,
                'name' => 'Bolld Care Ocean Fresh Antiperspirant & Anti-Sweat Deodorant Roll-on for Men',
                'slug' => 'bolld-care-ocean-fresh-antiperspirant-anti-sweat-deodorant-roll-on-for-men-w4p4d',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Bolld Care Ocean Fresh Antiperspirant and Anti-sweat Deodorant Roll-on ensures all-day freshness with protection against bad odour and controls sweating. This roll-on is free from harmful chemicals and has also been dermatologist tested to ensure that it is safe for all skin types.</span></p><p><span style="color: rgb(0, 0, 0);">*Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Beat the heat: This anti-sweat roll-on is designed to help men with hyperhidrosis and reduce excessive sweating. Get an instant cooling sensation and a long-lasting fragrance!</span></p><p><span style="color: rgb(0, 0, 0);">-Alcohol-free: This anti-sweat roll-on is completely alcohol-free to ensure that it is safe for daily usage on your skin. The roll-on is also dermatologist tested to ensure that it is safe for all skin types.</span></p><p><span style="color: rgb(0, 0, 0);">-Free from harmful chemicals: Bold Care Ocean Fresh Anti-sweat Roll On for Men is designed to be completely safe for daily usage. It doesn\'t contain any harmful chemicals and is sulphate and paraben free for your safety.</span></p>',
                'brand_id' => 14,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 65.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/bold_care_ocean_fresh_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:12:41',
                'updated_at' => '2023-09-26 12:12:41',
                'deleted_at' => null,
            ],
            52 => [
                'id' => 53,
                'name' => 'Doove Men + Care Sport Active + Fresh Dry Spray Antiperspirant Deodorant',
                'slug' => 'doove-men-care-sport-active-fresh-dry-spray-antiperspirant-deodorant-kqmgz',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Feel The Freshness With Dove Men+Care Sport Active + Fresh Deodorant Spray, You Get To Feel The Long-Lasting Freshness That Stays Ceaseless And Exhilarates Your Mood For Up To 48 Hours</span></p><p><span style="color: rgb(0, 0, 0);">-Powerful Fragrance: Dove’S Antiperspirant Deodorant Brings You A Unique, Powerful &amp; Soothing Formula That Gets Instantly Dry To Give You An Instant Fresh Feel. This Dry Spray Has An Irrevocably Appealing And Subtle Long-Lasting Fragrance That Cheers You Up For A Refreshing &amp; Thrilling Day</span></p><p><span style="color: rgb(0, 0, 0);">-Protection From Sweat &amp; Odour: An Antiperspirant Deodorant Made To Boost Your Comfort Level And Raise Your Confidence. Dove Sport Active &amp; Fresh Dry Spray Offers You Protection From Sweat And Odour For Up To 48 Hours</span></p><p><span style="color: rgb(0, 0, 0);">-Dove’S Care For Men: Made With 1/4 Moisturising Technology, Dove Body Spray For Men Soothes And Conditions Skin Giving It A Comforting Feel. The Moisturising Formula Also Hydrates Skin To Protect It Against Irritation &amp; Dryness</span></p><p><span style="color: rgb(0, 0, 0);">-Comfort That Your Skin Loves:The Antiperspirant Deo Spray For Men Is Dermatologically Proven And Skin-Friendly. Dove Deo Spray Is Surely Tough On Sweat But Not On The Skin</span></p>',
                'brand_id' => 14,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 75.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/dove_men_dry_spray_antiperspirant_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:14:52',
                'updated_at' => '2023-09-27 09:50:18',
                'deleted_at' => null,
            ],
            53 => [
                'id' => 54,
                'name' => 'Moii By Nykaaa Mini Pocket Perfume - Joie De Vivre',
                'slug' => 'moii-by-nykaaa-mini-pocket-perfume-joie-de-vivre-mxhle',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Moii by Nykaaa is a collection of fragrances that takes its name from the French word ‘moi’ translating to ‘me’. The collection is crafted as a fragrance wardrobe, to offer you a scent for every mood. These mini versions are easy to carry so you can now travel with your signature fragrances!</span></p>',
                'brand_id' => 6,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 70.0,
                'max_price' => 90.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 29,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/moi_by_nykaa_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:17:04',
                'updated_at' => '2023-09-26 12:17:04',
                'deleted_at' => null,
            ],
            54 => [
                'id' => 55,
                'name' => 'Rammsons You are lovely Eau De Perfume',
                'slug' => 'rammsons-you-are-lovely-eau-de-perfume-kh79u',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*Top note:</span></p><p><span style="color: rgb(0, 0, 0);">Bergamot, Peach, Orange, Grapefruit, Aquatic</span></p><p><span style="color: rgb(0, 0, 0);">*Heart note:</span></p><p><span style="color: rgb(0, 0, 0);">Bergamot, Peach, Orange, Grapefruit, Aquatic</span></p><p><span style="color: rgb(0, 0, 0);">*Base note:</span></p><p><span style="color: rgb(0, 0, 0);">Woody, Musk, Vanilla, Amber</span></p>',
                'brand_id' => 7,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 30.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 25,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/ramsons_you_are_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:19:04',
                'updated_at' => '2023-09-27 09:50:19',
                'deleted_at' => null,
            ],
            55 => [
                'id' => 56,
                'name' => 'mCaaffeine Coffee Body Butter With Berries',
                'slug' => 'mcaaffeine-coffee-body-butter-with-berries-vtpom',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*Deeply Moisturizes:</span></p><p><span style="color: rgb(0, 0, 0);">-A rich blend of Shea Butter &amp; Vit C rich Berries extract, it provides deep and long-lasting moisturization.</span></p><p><span style="color: rgb(0, 0, 0);">*Nourishes Dry Skin:</span></p><p><span style="color: rgb(0, 0, 0);">-This non-sticky &amp; non-greasy Body Butter nourishes and hydrates dry skin, and heals rough patches.</span></p><p><span style="color: rgb(0, 0, 0);">*Softens &amp; Smoothes Skin:</span></p><p><span style="color: rgb(0, 0, 0);">-This fast-absorbing Butter offers intense moisturization that softens dry patches and soothes itchy skin.</span></p><p><span style="color: rgb(0, 0, 0);">*Fruity Coffee-Berry Aroma:</span></p><p><span style="color: rgb(0, 0, 0);">-The buttery blend of Coffee &amp; Berries makes the skin smooth, as the irresistible aroma refreshes the senses.</span></p>',
                'brand_id' => 4,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 89.0,
                'max_price' => 89.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/mcaffeine_coffee_body_butter_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:20:43',
                'updated_at' => '2023-09-26 12:20:43',
                'deleted_at' => null,
            ],
            56 => [
                'id' => 57,
                'name' => 'Nykaaa Wanderlust Strawberry Daiquiri Body Yogurt',
                'slug' => 'nykaaa-wanderlust-strawberry-daiquiri-body-yogurt-dh61g',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Wanderlust Bath &amp; Body Collection, bottles up all your travel experiences with fragrances that still linger at the back of your head. Let\'s revisit those lands and fill your heart with memories with our floral fragrance and treat your skin to the comfort and well-being it deserves! Key Features</span></p><p><span style="color: rgb(0, 0, 0);">*Light weight moisturizer</span></p><p><span style="color: rgb(0, 0, 0);">-Gel-Based, non-greasy formula</span></p><p><span style="color: rgb(0, 0, 0);">-Absorbs instantly, hydration lasts upto 8 hours</span></p><p><span style="color: rgb(0, 0, 0);">-Enriched with AHAS</span></p>',
                'brand_id' => 6,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 60.0,
                'max_price' => 95.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 55,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/wanderlust_strawberry_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:22:53',
                'updated_at' => '2023-09-26 12:22:53',
                'deleted_at' => null,
            ],
            57 => [
                'id' => 58,
                'name' => 'Lovve Beauty & Planet Aloe Vera & Eucalyptus Hydro Body Gel',
                'slug' => 'lovve-beauty-planet-aloe-vera-eucalyptus-hydro-body-gel-vtope',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Natural Aloe Vera</span></p><p><span style="color: rgb(0, 0, 0);">-our quick-absorbing hydrating gel is made with aloe vera cultivated in Mexico. It\'s packed with vitamins A,C, E, antioxidants &amp; enzymes to intensely hydrate &amp; soothe skin</span></p><p><span style="color: rgb(0, 0, 0);">-plant-based moisturizers</span></p><p><span style="color: rgb(0, 0, 0);">-100% vegan</span></p><p><span style="color: rgb(0, 0, 0);">-PETA certified cruelty-free</span></p>',
                'brand_id' => 14,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 60.0,
                'max_price' => 120.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 70,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/love_beauty_planet_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:24:54',
                'updated_at' => '2023-09-26 12:24:54',
                'deleted_at' => null,
            ],
            58 => [
                'id' => 59,
                'name' => 'Nykaaa Wanderlust Mediterranean Sea Salt Body Yogurt',
                'slug' => 'nykaaa-wanderlust-mediterranean-sea-salt-body-yogurt-c4qvc',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Wanderlust Bath &amp; Body Collection, bottles up all your travel experiences with fragrances that still linger at the back of your head.</span></p><p><span style="color: rgb(0, 0, 0);">-Let\'s revisit those lands and fill your heart with memories with our floral fragrance and treat your skin to the comfort and well-being it deserves!</span></p><p><span style="color: rgb(0, 0, 0);">*Key Features</span></p><p><span style="color: rgb(0, 0, 0);">-Light weight moisturizer</span></p><p><span style="color: rgb(0, 0, 0);">-Gel-Based, non-greasy formula</span></p><p><span style="color: rgb(0, 0, 0);">-Absorbs instantly, hydration lasts upto 8 hours</span></p><p><span style="color: rgb(0, 0, 0);">-Enriched with AHAs</span></p>',
                'brand_id' => 6,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 68.0,
                'max_price' => 68.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/wanderlust_mediterranean_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:27:03',
                'updated_at' => '2023-09-26 12:27:03',
                'deleted_at' => null,
            ],
            59 => [
                'id' => 60,
                'name' => 'Lorreal Pariis Glycolic Bright Day Cream With SPF17 Glycolic Acid & Niacinamide Reduces Dark Spots',
                'slug' => 'lorreal-pariis-glycolic-bright-day-cream-with-spf17-glycolic-acid-niacinamide-reduces-dark-spots-a4ro0',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">SCIENCE OF GLYCOLIC ACID</span></p><p><span style="color: rgb(0, 0, 0);">*WHAT IS IT?</span></p><p><span style="color: rgb(0, 0, 0);">-Glycolic Acid is the smallest and the lightest Alpha-Hydroxy Acid molecule which is used by Dermatologists to treat dark spots.</span></p><p><span style="color: rgb(0, 0, 0);">*HOW DOES IT WORK?</span></p><p><span style="color: rgb(0, 0, 0);">-It goes deep into the skin and removes melanin to reduce dark spots.</span></p><p><span style="color: rgb(0, 0, 0);">-It also works on the skin surface and removes dead cells to reveal bright skin.</span></p>',
                'brand_id' => 14,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 55.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 70,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/loreal_paris_glycolic_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:29:49',
                'updated_at' => '2023-09-26 12:29:49',
                'deleted_at' => null,
            ],
            60 => [
                'id' => 61,
                'name' => 'Lekme Absolute Perfect Radiance Skin Brightening Day Creme',
                'slug' => 'lekme-absolute-perfect-radiance-skin-brightening-day-creme-wfh00',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">*Reveal Hi-Res Crystal Radiance with the Skin Brightening Day Crème</span></p><p><span style="color: rgb(0, 0, 0);">-Bright &amp; illuminated look</span></p><p><span style="color: rgb(0, 0, 0);">-Mattifying look</span></p><p><span style="color: rgb(0, 0, 0);">-With sunscreens that help to protect from harmful rays</span></p><p><span style="color: rgb(0, 0, 0);">*HOW TO USE</span></p><p><span style="color: rgb(0, 0, 0);">-Lightly scoop out the creme.</span></p><p><span style="color: rgb(0, 0, 0);">-Dot your forehead, cheeks, nose and chin.</span></p><p><span style="color: rgb(0, 0, 0);">-Gently massage the creme in circular motions.</span></p>',
                'brand_id' => 9,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 64.0,
                'max_price' => 64.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/personal_care_products/lakme_absolute_perfect_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:32:04',
                'updated_at' => '2023-09-26 12:32:04',
                'deleted_at' => null,
            ],
            61 => [
                'id' => 62,
                'name' => 'Agaaro HD-1120 2000 Watts Professional Hair Dryer With Ac Motor',
                'slug' => 'agaaro-hd-1120-2000-watts-professional-hair-dryer-with-ac-motor-jwyvv',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Professional hair dryer that styles hair effortlessly</span></p><p><span style="color: rgb(0, 0, 0);">-Powerful AC motor delivers the perfect airflow and temperature</span></p><p><span style="color: rgb(0, 0, 0);">-Features 2 speed and 3 temperature settings for easy styling</span></p><p><span style="color: rgb(0, 0, 0);">-Cool shot button provides a burst of cold air to set the hairstyle</span></p><p><span style="color: rgb(0, 0, 0);">-Auto shut-off function prevents overheating</span></p><p><span style="color: rgb(0, 0, 0);">-The dryer has a 2.5 meter long cord for ease of movement</span></p><p><span style="color: rgb(0, 0, 0);">-Attachments: Diffuser, concentrator nozzle, and comb attachments</span></p>',
                'brand_id' => 12,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 70.0,
                'max_price' => 70.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/agaro_hd_1120_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:34:50',
                'updated_at' => '2023-09-26 12:34:50',
                'deleted_at' => null,
            ],
            62 => [
                'id' => 63,
                'name' => 'Ikoniq Me 3 In 1 Express Styler - Pink',
                'slug' => 'ikoniq-me-3-in-1-express-styler-pink-xhbum',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-The 3 in 1 express styler combines a conventional blow dryer with a volumizer and a styler. It can produce excellent results and versatile styling on all types of hair.</span></p><p><span style="color: rgb(0, 0, 0);">*Features:</span></p><p><span style="color: rgb(0, 0, 0);">-All Rounder Hair Styler: The use of a hair dryer and styling comb together is ideal. You can blow-dry your hair while also straightening or curling it! Frizz Free blow-dry in half the time or less.</span></p><p><span style="color: rgb(0, 0, 0);">-Brush Head: Brush head make straightening, curling, and volumizing a breeze.</span></p><p><span style="color: rgb(0, 0, 0);">-Head Released Button: Easy to change brush heads just by pressing the button.</span></p><p><span style="color: rgb(0, 0, 0);">-Ceramic Titanium Tourmaline Coated Barrel: Helps reduce damage from over styling.</span></p><p><span style="color: rgb(0, 0, 0);">-Innovative Airflow Vents: For better coverage and quicker drying.</span></p><p><span style="color: rgb(0, 0, 0);">-Mixed Styling Bristes: Helps grip and dry hair faster for smooth, voluminous results.</span></p><p><span style="color: rgb(0, 0, 0);">-More Volume 2.4 Oval Head Barrel: For close to root styling and boosting volume.</span></p><p><span style="color: rgb(0, 0, 0);">-75% Shinier: Blowouts that are 75% shinier and take half as long.</span></p><p><span style="color: rgb(0, 0, 0);">-220-240V 50/60Hz Class II 1200W.</span></p>',
                'brand_id' => 15,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 80.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/ikonic_me_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:36:24',
                'updated_at' => '2023-09-26 12:36:24',
                'deleted_at' => null,
            ],
            63 => [
                'id' => 64,
                'name' => 'Havellss HC4085 - 1000 Watts Air Care Styler, Pre-Styling Half Brush and Drying Nozzle, Styling Curlers, Smoothening Roller Brush; Suitable for All Hair Types (Black)',
                'slug' => 'havellss-hc4085-1000-watts-air-care-styler-pre-styling-half-brush-and-drying-nozzle-styling-curlers-smoothening-roller-brush-suitable-for-all-hair-types-black-h3ikp',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Pre-styling half brush comb and nozzle - dries the wet hair, to prep for styling</span></p><p><span style="color: rgb(0, 0, 0);">-Soft smoothing roller brush - use for natural straight hair or big curls</span></p><p><span style="color: rgb(0, 0, 0);">-Shrinkable style brush - to give volume and shape fine, flat hair</span></p><p><span style="color: rgb(0, 0, 0);">-19 mm curling iron - to create beautiful s curls</span></p><p><span style="color: rgb(0, 0, 0);">-3 temperature settings- cool, warm and hot settings for perfect end result</span></p><p><span style="color: rgb(0, 0, 0);">-1000 w creates optimum level of airflow for a gentle drying</span></p><p><span style="color: rgb(0, 0, 0);">-1.8 m power cord - ensures comfort and flexibility</span></p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 100.0,
                'max_price' => 100.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/havells_hc4085_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:38:21',
                'updated_at' => '2023-09-26 12:38:21',
                'deleted_at' => null,
            ],
            64 => [
                'id' => 65,
                'name' => 'Pheelips BHH816/00 Crimp, Straighten or Curl with the single tool, quickly and without fear of heat damage & 50 Watt Thermo Protect Technology Heated Hair Straightening Brush',
                'slug' => 'pheelips-bhh81600-crimp-straighten-or-curl-with-the-single-tool-quickly-and-without-fear-of-heat-damage-50-watt-thermo-protect-technology-heated-hair-straightening-brush-m8rpa',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Product 1: Create your favourite styles, from sleek and chic straight hair to effortlessly casual waves, or beautiful textured crimps - you can do it all</span></p><p><span style="color: rgb(0, 0, 0);">-Product 1: Crimper for defined textures - Crimper plates for defined textures, gives hair a more layered look</span></p><p><span style="color: rgb(0, 0, 0);">-Product 2: Silk ProCare to minimize heat damage on hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Product 2: Large Paddle -shaped brush to straighten more hair in one go</span></p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 70.0,
                'max_price' => 70.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/philips_crimp_straighten_or_curl_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:40:30',
                'updated_at' => '2023-09-26 12:40:30',
                'deleted_at' => null,
            ],
            65 => [
                'id' => 66,
                'name' => 'Pheelips BHHS397/40 Kerashine Titanium Straightener With SilkProtect Technology',
                'slug' => 'pheelips-bhhs39740-kerashine-titanium-straightener-with-silkprotect-technology-0j98f',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Keratin ceramic plates for smooth gliding and shiny hair: This straightener has keratin infused ceramic plates for ultimate shine and ultrasmooth gliding.</span></p><p><span style="color: rgb(0, 0, 0);">-Ionic care for shiny, frizz-free hair: Charged negative ions eliminate static, condition the hair and smooth down the hair cuticles to intensify the hair\'s shine and glossiness. The result is smooth, frizz-free hair with vibrant shine.</span></p><p><span style="color: rgb(0, 0, 0);">-Fast heat-up time, ready to use in 60 sec: The straightener has a fast heat-up time, being ready to use in 60 seconds.</span></p><p><span style="color: rgb(0, 0, 0);">-2 temperature settings: Lower temperature for last minute touch ups and gentle styling. Higher temperature for long lasting results.</span></p><p><span style="color: rgb(0, 0, 0);">-210C professional high heat for perfect salon results: This high temperature enables you change the shape of your hair and gives you that perfect look like you\'ve just come from the salon.</span> </p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/philips_bhs397_40_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:41:57',
                'updated_at' => '2023-09-26 12:41:57',
                'deleted_at' => null,
            ],
            66 => [
                'id' => 67,
                'name' => 'Hair Styling Comb Set Teasing Hair Brush Rat Tail Comb Edge Brush for Edge&Back Brushing, Combing, Slicking Hair for Women (Black)',
                'slug' => 'hair-styling-comb-set-teasing-hair-brush-rat-tail-comb-edge-brush-for-edgeback-brushing-combing-slicking-hair-for-women-black-xizf9',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-What you get: You will receive 2 piece of double sided hair edge brush, 2 piece of 3 row salon teasing brush, 2 piece of rat tail comb,6 piece of hair clips, you will have a nice combination set for your hair care.</span></p><p><span style="color: rgb(0, 0, 0);">-Convenient to use: The double sided hair edge brush can bring convenience to your hair design, because their size can be easily held in your hand, which brings convenience for rotating and changing the position of hair combing, so you can control the hair well and fix them.</span></p><p><span style="color: rgb(0, 0, 0);">-Functions: They are suitable for combing bangs, hairlines, hair edge, eyebrows and eyelashes, back hair, or parting hair. You can also add hair stick or wax to make your hairstyle more beautiful during using.</span></p><p><span style="color: rgb(0, 0, 0);">-Practical design: The handle of hair edge brush is designed according to ergonomics, which is comfortable and convenient, so it can be applied at multiple angles and can be applied easily, making your use effortlessly.</span></p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 56.0,
                'max_price' => 56.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/hair_styling_comb_set_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:43:37',
                'updated_at' => '2023-09-26 12:43:37',
                'deleted_at' => null,
            ],
            67 => [
                'id' => 68,
                'name' => 'Hair section clips set of 6 red Professional Hair Styling Plastic Clips Sectioning, Non-Slip Hairdresser for Thick Hair Large Hairpin for Women',
                'slug' => 'hair-section-clips-set-of-6-red-professional-hair-styling-plastic-clips-sectioning-non-slip-hairdresser-for-thick-hair-large-hairpin-for-women-j6xto',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-High quality – Premium hair clips with a high elasticity metal spring which last long even after repeated use. Strong and durable plastic clips can hold hair tight.</span></p><p><span style="color: rgb(0, 0, 0);">-Wide teeth styling hair clip - This set of 6 hair clips are designed with wide teeth to keep your hair in place without leaving a dent, These great hair sectioning clips make styling and hair drying easier.</span></p><p><span style="color: rgb(0, 0, 0);">-No slip - Non-slip grip secures the hold and prevents your fingers from slipping. Clips are also finger length, curved to the contour of the head. These hair clips hold even large sections of hair without slipping or damaging. They can easily be used to pin up hair without pinching!</span></p><p><span style="color: rgb(0, 0, 0);">-Made for hairstylists – These crocodile clips are perfect for straightening, coloring, blow-drying, cutting, and styling every men and women\'s hair. different size teeth adjust to hold any kind of hair regardless of amount, thickness, or type. They’re also perfect use for Holding Foils in place during applications of hair coloring, bleaching, and treatments.</span></p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 63.0,
                'max_price' => 63.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/hair_section_clips_set_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:46:23',
                'updated_at' => '2023-09-26 12:46:23',
                'deleted_at' => null,
            ],
            68 => [
                'id' => 69,
                'name' => 'Miraamar 4 PCS Hair Stylists Professional Styling Comb Set Variety Pack Great for All Hair Types & Styles Paddle and Round Hair Brush Straightener For Women/Men, Dressing Comb for women',
                'slug' => 'miraamar-4-pcs-hair-stylists-professional-styling-comb-set-variety-pack-great-for-all-hair-types-styles-paddle-and-round-hair-brush-straightener-for-womenmen-dressing-comb-for-women-a8wac',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Package Include: This 4 Pieces Pro Set (1 Paddle brush, 1 Round Hair Straightener and 2 dressing Comb/ kanghi), includes everything you could possibly need, Total 4 Pcs. It is suitable for all kinds of hair. It is a good helper for keeping your hair smooth.</span></p><p><span style="color: rgb(0, 0, 0);">-Professional styling comb: Wide tooth rat tail comb, Fine tooth pin tail comb,3 in 1 comb, Fine tooth rat tail comb, Coarse and Fine Toothed Pocket Comb, Tail Comb,Triple Teasing Comb, Waves Pick Comb. Detangling Comb. Styling comb. These are Professional styling comb collection, Keep your perfect hairstyle anytime, anywhere.</span></p><p><span style="color: rgb(0, 0, 0);">-Great material: Professional anti-static plastic. Won\'t scratch your scalp or get caught in knots, Works well with hair styling and chemical treatments. Color: Black</span></p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 40.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/miramar_4_pcs_hair_stylists_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:48:07',
                'updated_at' => '2023-09-26 12:48:07',
                'deleted_at' => null,
            ],
            69 => [
                'id' => 70,
                'name' => 'Vaga E18-PB Paddle Hair Brush',
                'slug' => 'vaga-e18-pb-paddle-hair-brush-sgvgv',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">The Vega Paddle Brush with Cleanser has a handle designed for greater comfort. It has well balanced flexible and superior design of bristles. It is hygienic and easy to clean.</span></p><p><span style="color: rgb(0, 0, 0);">-Suitable for short to long hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Has an ergonomic handle.</span></p><p><span style="color: rgb(0, 0, 0);">-Features flexible and superior design of bristles.</span></p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 52.0,
                'max_price' => 52.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/vega_e18_pb_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:49:27',
                'updated_at' => '2023-09-27 09:50:28',
                'deleted_at' => null,
            ],
            70 => [
                'id' => 71,
                'name' => 'Streeak Street Hair Scalp Massager & Shampoo Brush - Cobalt Blue - Promotes Hair Growth',
                'slug' => 'streeak-street-hair-scalp-massager-shampoo-brush-cobalt-blue-promotes-hair-growth-8ntbs',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Streak Street Smooch Pink Hair Scalp Massager and Shampoo Brush has silicone bristles that massage the scalp and help enhance blood circulation, thereby enhancing hair growth. This shampoo brush is designed specifically for lathering and exfoliating the scalp hence delivering a deeper cleanse. Its gentle stimulation of the scalp helps improve the circulation of oxygen.</span></p><p><span style="color: rgb(0, 0, 0);">*Features:</span></p><p><span style="color: rgb(0, 0, 0);">-Shampoo brush and scalp massager that helps enhance blood circulation</span></p><p><span style="color: rgb(0, 0, 0);">-Designed specifically to provide a deep cleansing and exfoliating effect</span></p><p><span style="color: rgb(0, 0, 0);">-Removes excess oils, dirt and dandruff flakes without irritating your skin</span></p><p><span style="color: rgb(0, 0, 0);">-Fits in any travel bag for your next vacation</span></p><p><span style="color: rgb(0, 0, 0);">-Suitable for all hair types</span></p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 48.0,
                'max_price' => 48.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 40,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/streak_street_hair_scalp_massager_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:50:47',
                'updated_at' => '2023-09-26 12:50:47',
                'deleted_at' => null,
            ],
            71 => [
                'id' => 72,
                'name' => 'Shower Cap for Women Reusable Waterproof Hair Dye Color Mixing Bowl, Brush Set Hair Colouring Kit for Salon Use for Men & Women Bathing Hair Cap with Lace Elastic Band Beauty Hair Spa(7pcs)',
                'slug' => 'shower-cap-for-women-reusable-waterproof-hair-dye-color-mixing-bowl-brush-set-hair-colouring-kit-for-salon-use-for-men-women-bathing-hair-cap-with-lace-elastic-band-beauty-hair-spa7pcs-wzy2k',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Material: Shower Caps Are Made From EVA Material Which Is Non Toxic Material. They Are Wear Resistant, Waterproof Giving You A Comfortable Feel While You Bath Or Condition Your Hair.</span></p><p><span style="color: rgb(0, 0, 0);">-REUSABLE USE: Make Your Hair Coloring Experience Easy, Neat and Clean, Full Brushes are Designed with flexible; All Tools Are Easy to Clean for Reusable Use, Chemical resistant, heat-resistant, Anti-static, Make Your Hair Coloring Experience Easy, neat and CLean.</span></p><p><span style="color: rgb(0, 0, 0);">-Perfect for salon, spa, hairdressing, DIY, at-home dyeing, balayage, role-playing, micro braiding, foiling, highlights, keratin hair treatment and or other crafts blends; 3 different shapes of brushes are suitable for any hairstyles such as short or long hair, curly or straight hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Widely use: You can wear it in the shower to prevent the hair from getting wet, or to prevent dust when cleaning.</span></p>',
                'brand_id' => 15,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 75.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/shower_cap_for_women_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:52:12',
                'updated_at' => '2023-09-26 12:52:12',
                'deleted_at' => null,
            ],
            72 => [
                'id' => 73,
                'name' => 'Schoool furniture Beauty Parlour/Salon/Barber/Cutting/Makeup/Makeover/Stylish Chair with Push Back System & Hydraulic System Leather Cushion seat Back (Black)',
                'slug' => 'schoool-furniture-beauty-parloursalonbarbercuttingmakeupmakeoverstylish-chair-with-push-back-system-hydraulic-system-leather-cushion-seat-back-black-bxpdv',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Style: Modern &amp; Attractive Chair, Color: Black</span></p><p><span style="color: rgb(0, 0, 0);">-Hydraulic &amp; Push back system available</span></p><p><span style="color: rgb(0, 0, 0);">-Heavy Duty Salon Chair</span></p>',
                'brand_id' => 15,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 100.0,
                'max_price' => 100.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/school_furniture_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:53:51',
                'updated_at' => '2023-09-26 12:53:51',
                'deleted_at' => null,
            ],
            73 => [
                'id' => 74,
                'name' => 'Takeera Salon Barber Spa Beauty Equipment,Baby Salon Booster Cushion for Child Hair Cutting Styling Chair,Barber Shop Hair Dressing Equipment for Kids',
                'slug' => 'takeera-salon-barber-spa-beauty-equipmentbaby-salon-booster-cushion-for-child-hair-cutting-styling-chairbarber-shop-hair-dressing-equipment-for-kids-4uyzy',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Safe kids booster seat for salon: The salon seat cushion is made of premium leather and upgrade breathable,non slip surface to make it safer for kids hair cutting, not easy to slip down.Perfect for your barbershop stylish salon chair.</span></p><p><span style="color: rgb(0, 0, 0);">-Comfortable and Proper Height: Filled with quality high density sponge which is 6.5’’ thick, 0.2” thicker than normal salon booster,adds more comfort and extra height.The booster barber seat is well elastic that it can perfectly recover its original shape even after long-time use.</span></p><p><span style="color: rgb(0, 0, 0);">-Waterproof and Easy to Clean: This child booster seat for hairdressing is covered by soft superior PU leather,water proof to keep sponge well even after a long time usage. So it can be easy to clean with wet cloth,easy to wipe up hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Large Size: Large size 14.5”x11"x5.5"(L x W x H),fits most standard styling chair on the market.Ideal size for small or big children</span></p><p><span style="color: rgb(0, 0, 0);">-Quality Assurance: We offer 30 days free refund&amp;return service, one year quality Assurance. Please no hesitation to add to cart right now!</span></p>',
                'brand_id' => 15,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 120.0,
                'max_price' => 120.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 80,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/takira_salon_barber_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:55:18',
                'updated_at' => '2023-09-26 12:55:18',
                'deleted_at' => null,
            ],
            74 => [
                'id' => 75,
                'name' => 'Seelver Frame Storage Trolley Hairdresser Cart Barber Beauty Hairdressing Mobile Serving Cart with 5 Drawers for Salon Spa, Black',
                'slug' => 'seelver-frame-storage-trolley-hairdresser-cart-barber-beauty-hairdressing-mobile-serving-cart-with-5-drawers-for-salon-spa-black-qv1qa',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Multiple Uses - suitable for beauty salon, tattoo, nail art, pet grooming and other uses. Can also be used as a storage trolley for kitchen, bedroom, bathroom, storage room, convenient and practical. Ideal for commercial and domestic use.</span></p><p><span style="color: rgb(0, 0, 0);">-Upgraded and Reinforced Construction - for being able to carry more items. There are 2 iron sides, 6 iron lateral support bars and 4 all-metal wheels to make it stable and wobble-free. Compared to plastic trolleys, the load-bearing capacity is increased by 50%.</span></p><p><span style="color: rgb(0, 0, 0);">-Generous Storage Space - The upgrade has increased the capacity of the drawers, with 5 levels of storage space for more items. The first level is an ample worktop, suitable for a variety of tools. The four removable drawers below are also more spacious.</span></p><p><span style="color: rgb(0, 0, 0);">-Easy to Install-after unpacking, all you need to do is tighten the screws and ready to use. No specialist installation or power tools are required. Easy to remove and clean, dirt resistant.</span></p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 89.0,
                'max_price' => 89.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 60,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/silver_frame_storage_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:57:24',
                'updated_at' => '2023-09-26 12:57:24',
                'deleted_at' => null,
            ],
            75 => [
                'id' => 76,
                'name' => 'Woodden Portable Foldable Spa Massage Tables/Beauty Bed with Headrest and Armrest Salon Furniture, 60 cm Width, 250 kg Bearing',
                'slug' => 'woodden-portable-foldable-spa-massage-tablesbeauty-bed-with-headrest-and-armrest-salon-furniture-60-cm-width-250-kg-bearing-lkbgo',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Colour: Brown</span></p><p><span style="color: rgb(0, 0, 0);">-Shape: Rectangular</span></p><p><span style="color: rgb(0, 0, 0);">-Size: 27x60x80 cm (Pack of 1)</span></p><p><span style="color: rgb(0, 0, 0);">-Carton Dimensions (L x W x H): 95 x 20 x 18 cm</span></p><p><span style="color: rgb(0, 0, 0);">-Product Weight: 15 kg</span></p><p><span style="color: rgb(0, 0, 0);">-Product Dimensions (L x W x H): 27 x 80 x 60 cm</span></p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 95.0,
                'max_price' => 95.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/wooden_portable_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 12:58:40',
                'updated_at' => '2023-09-26 12:58:40',
                'deleted_at' => null,
            ],
            76 => [
                'id' => 77,
                'name' => 'Pheelips Multi Grooming Kit MG3710/65, 9-in-1 (New Model), Face, Head and Body - All-in-one Trimmer for Men Self Sharpening Stainless Steel Blades, No Oil Needed, 60 Mins Run Time',
                'slug' => 'pheelips-multi-grooming-kit-mg371065-9-in-1-new-model-face-head-and-body-all-in-one-trimmer-for-men-self-sharpening-stainless-steel-blades-no-oil-needed-60-mins-run-time-0dadk',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-The 9-in-1 all-in-one trimmer allows you to trim and style your face, hair and body at home with maximum precision</span></p><p><span style="color: rgb(0, 0, 0);">-All your hair trimming needs at home. 7 impact-resistant combs 2 stubble combs (1, 2 mm), 1 adjustable beard comb (3-7 mm), 3 hair combs (9, 12, 16 mm) and 1 body comb (3 mm)</span></p><p><span style="color: rgb(0, 0, 0);">-Run time up to 60 minutes of cordless use per charge, no-slip rubber grip for improved comfort and control</span></p><p><span style="color: rgb(0, 0, 0);">-Self-sharpening, skin-friendly blades for a perfect trim</span></p><p><span style="color: rgb(0, 0, 0);">-Long lasting performance - 2 plus 1 Year warranty after registration</span></p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 65.0,
                'max_price' => 65.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/philips_multi_grooming_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 13:00:05',
                'updated_at' => '2023-09-26 13:00:05',
                'deleted_at' => null,
            ],
            77 => [
                'id' => 78,
                'name' => 'Mens Hair Clipper Hair Trimmer Beard Trimmer Cordless Hair Cutting Kit for Men Grooming Kit Precision Trimmer Waterproof Rechargeable, Battery Powered',
                'slug' => 'mens-hair-clipper-hair-trimmer-beard-trimmer-cordless-hair-cutting-kit-for-men-grooming-kit-precision-trimmer-waterproof-rechargeable-battery-powered-pdufd',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-All-in-One Grooming - 3 multipurpose attachments are perfect for all facial hair styles: Hair Trimmer, Beard Trimmer, Detail Trimmer. For touch ups between hair clipping &amp; detail Trimming, mustaches, sideburns, goatees, stubble, other face &amp; body hair</span></p><p><span style="color: rgb(0, 0, 0);">-Complete Set Of Attachment Guards: 1 PRECISION DIAL from 3mm to 8mm, 5-DEGREE TUNABLE BLADE from 0.5mm to 2.5mm, 6 GUIDE COMBS(3mm, 4-6mm, 7-9mm, 10-12mm, 16-18mm, 22-24mm), to achieve a wide variety of hairstyles and lengths</span></p><p><span style="color: rgb(0, 0, 0);">-Self-sharpening Titanium Ceramic Blade: The combination of titanium and ceramic blades achieves a delicate haircut fit for all kinds of hair of kids,adults,men,the elderly,professional salon,etc. The blade can be easily removed convenient for cleaning. Its self-sharpening system keeps fine sharpness for long-lasting performance</span></p><p><span style="color: rgb(0, 0, 0);">-High Capacity Lithium Battery: Full charge in 1.5h, the fast charging 800mAh Li battery can deliver strong power up to 90 mins of runtime</span></p><p><span style="color: rgb(0, 0, 0);">-What\'s in the package you will receive : a hair clipper, a beard trimmer head, a detail trimmer, a precision dial, 6 guide comb, a hair comb , a charger withh USB connection, a charger stand, a clean brush</span></p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 75.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/salon_equipment_and_tools/mens_hair_clipper_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-26 13:01:37',
                'updated_at' => '2023-09-26 13:01:37',
                'deleted_at' => null,
            ],
            78 => [
                'id' => 79,
                'name' => 'Faveela Metal Pearl Hair Clips 6 Pieces Pearl Hair Clips For Women Korean Women Hairpins Girl Geometric Hair Hair Accessories Hair Barrettes Hair Accessories for Women Girls',
                'slug' => 'faveela-metal-pearl-hair-clips-6-pieces-pearl-hair-clips-for-women-korean-women-hairpins-girl-geometric-hair-hair-accessories-hair-barrettes-hair-accessories-for-women-girls-4mkhh',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">-Geometric Design Alloy Hair Pins: The special design with the Geometric style of these hair hairpins can let you have a charming and elegant hairstyle, beautiful hair clips match almost all outfits, hair colors, and hairstyles.</span></p><p><span style="color: rgb(0, 0, 0);">-Metal Hair Clips: For Alloy material makes this hair clip exquisite and high quality, Make you charmer and elegant.</span></p><p><span style="color: rgb(0, 0, 0);">-Variety of Shapes: The fancy geometric design is pretty, more simple more fashionable, will make you charming, elegant, and get more compliments for you.</span></p><p><span style="color: rgb(0, 0, 0);">-Occasions: These trendy hairpins are used for decorative daily wear or dress up for any occasion\'s hairstyles decorations, prom, party or give out as a gift.</span></p><p><span style="color: rgb(0, 0, 0);">-Great Accessory And Hair Decoration For Girls, Women ,Perfect size</span> </p>',
                'brand_id' => 11,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 68.0,
                'max_price' => 68.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/favela_metal_pearl_hair_clips_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:04:34',
                'updated_at' => '2023-09-27 05:04:34',
                'deleted_at' => null,
            ],
            79 => [
                'id' => 80,
                'name' => 'Multicolor Pearl Headband Children Streamer Hair Accessories Baby Cute Princess Headband With Ribbon For Girls (Random Color)',
                'slug' => 'multicolor-pearl-headband-children-streamer-hair-accessories-baby-cute-princess-headband-with-ribbon-for-girls-random-color-sucgb',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Fashionable pearl girl headbands are ideal gifts choice for your friends and family. Give your lover, families and friends a sweet present on birthday party, anniversary, Mother\'s day, Thanksgiving Day, Christmas Day, Valentine’s Day, New Year’s Day.</span></p><p><span style="color: rgb(0, 0, 0);">-headband is adjustable and flexible, which can be bent and adjusted to suit people of many different ages and head circumferences.</span></p><p><span style="color: rgb(0, 0, 0);">-Headbands made of artificial pearls, alloys and rhinestones, the delicate appearance of pearl headbands will be loved by most women and girls</span></p><p><span style="color: rgb(0, 0, 0);">-Wonderful headband for yourself wear them as you like or share with your girlfriends, sisters, mother etc. Give it as a perfect gift on birthdays, anniversaries, valentine\'s day, mother\'s day or any other festivals.</span></p>',
                'brand_id' => 11,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 48.0,
                'max_price' => 48.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/multicolor_pearl_headband_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:05:58',
                'updated_at' => '2023-09-27 05:05:58',
                'deleted_at' => null,
            ],
            80 => [
                'id' => 81,
                'name' => 'Yelloow Chimes Set of 8 Pcs Multicolor Matte Finishing Big Hair Clip',
                'slug' => 'yelloow-chimes-set-of-8-pcs-multicolor-matte-finishing-big-hair-clip-lyo6q',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">Set of 8 multicolor large size snap clips which you can use for Party / Smart Casual and Pair these hair clips with any party wear or smart casual wear to complete the looks.</span> </p>',
                'brand_id' => 16,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 35.0,
                'max_price' => 35.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/yellow_chimes_set_of_8_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:07:25',
                'updated_at' => '2023-09-27 05:07:25',
                'deleted_at' => null,
            ],
            81 => [
                'id' => 82,
                'name' => 'Artificial Stone and Pearls Made Bridal Attractive Hair Pins/Juda Pin for Women and Girls (Silver)',
                'slug' => 'artificial-stone-and-pearls-made-bridal-attractive-hair-pinsjuda-pin-for-women-and-girls-silver-5x4b2',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Each hairpin/clip is carefully crafted with attention to detail, ensuring an elegant and realistic floral design.</span></p><p><span style="color: rgb(0, 0, 0);">-The hairpins/clips are made from high-quality materials, ensuring durability and longevity.</span></p><p><span style="color: rgb(0, 0, 0);">-Material : Products are made of Artificial Flower which is fully skin friendly &amp; durable.</span></p><p><span style="color: rgb(0, 0, 0);">-Features: Lightweight, sturdy, comfortable, easy and durable to use. Age Range Description: 10 to 20 Years.</span></p><p><span style="color: rgb(0, 0, 0);">-Embrace the beauty of these artificial flowers and let them enhance your elegance and grace on your special day.</span></p>',
                'brand_id' => 17,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 40.0,
                'max_price' => 40.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/artificial_stone_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:09:04',
                'updated_at' => '2023-09-27 05:09:04',
                'deleted_at' => null,
            ],
            82 => [
                'id' => 83,
                'name' => 'Blaack Premium Metal Hair Clips Tic Tac Clip ,Bobby pin,Hair Pins and U-pin Juda pin Hair Styling Pins for Women and Girls for Daily use .Color:Tic tac pin,Matte Black. (Pack of 134)',
                'slug' => 'blaack-premium-metal-hair-clips-tic-tac-clip-bobby-pinhair-pins-and-u-pin-juda-pin-hair-styling-pins-for-women-and-girls-for-daily-use-colortic-tac-pinmatte-black-pack-of-134-96rat',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Combo of 134 hair clip,Pack of 48 pcs matte black tic tac hair clip,Pack of 36 black bobby pin,Pack of 50 black U pin.</span></p><p><span style="color: rgb(0, 0, 0);">-High quality double coated premium metal hair clip.</span></p><p><span style="color: rgb(0, 0, 0);">-These hair clips are stylish and easy to wear.</span></p><p><span style="color: rgb(0, 0, 0);">-Suitable for daily use kids DIY Crafts,No-slip grip technology stays in place all day.</span></p><p><span style="color: rgb(0, 0, 0);">-Durable and rust resistant, extra strong grip</span></p><p><span style="color: rgb(0, 0, 0);">-Essential combo for women and girls.</span></p>',
                'brand_id' => 14,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 20.0,
                'max_price' => 20.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/black_premium_metal_hair_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:10:19',
                'updated_at' => '2023-09-27 05:10:19',
                'deleted_at' => null,
            ],
            83 => [
                'id' => 84,
                'name' => 'Voyaage Multicolored Over Size Sunglasses for Women - 86585Mg3911',
                'slug' => 'voyaage-multicolored-over-size-sunglasses-for-women-86585mg3911-myces',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-A perfect blend of style and comfort, this pair of sunglasses from Voyage Sunglasses is worth investing in. The trendy colour combination of these sunglasses perfectly complements your cool sense of fashion. These sunglasses can be worn with any of your favourite outfits to complete your look for the day.</span></p><p><span style="color: rgb(0, 0, 0);">-The wonderful make of the lenses, protects your eyes from harmful UV rays of the sun.It is extremely lightweight and can be carried along in your bag for joyous sunny days.</span></p>',
                'brand_id' => 14,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 90.0,
                'max_price' => 90.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/voyage_multicolored_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:11:36',
                'updated_at' => '2023-09-27 05:11:36',
                'deleted_at' => null,
            ],
            84 => [
                'id' => 85,
                'name' => 'UVV Proteection Cat Eye Sunglasses For Women Stylish Catchme-C3 52',
                'slug' => 'uvv-proteection-cat-eye-sunglasses-for-women-stylish-catchme-c3-52-9otrl',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Ted Smith known for simplistic, stylish &amp; accessible fashion. The creative touch we give to our collection make us standout from rest of the high street brands.Inspired by the prestigious London clubs.</span></p><p><span style="color: rgb(0, 0, 0);">-The Ted Smith eyewear collection mixes heritage silhouettes with creative fashion twerks.We pride ourselves on being the perfect brand to pick up accents that glam up your overall look. We believe in the art of simplicity and creativity.</span></p>',
                'brand_id' => 12,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 65.0,
                'max_price' => 65.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1695772800,
                'discount_end_date' => 1695772800,
                'sell_target' => null,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 0,
                'max_purchase_qty' => 0,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 0,
                'express_delivery_hours' => 0,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/uv_protection_cat_eye_sunglasses_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:12:44',
                'updated_at' => '2023-09-27 05:13:16',
                'deleted_at' => null,
            ],
            85 => [
                'id' => 86,
                'name' => 'Joohn Jaacobs Unisex Adult Hexagon sunglasses Grey Frame, Grey Lens',
                'slug' => 'joohn-jaacobs-unisex-adult-hexagon-sunglasses-grey-frame-grey-lens-vihzw',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Care Instructions: hand wash only</span></p><p><span style="color: rgb(0, 0, 0);">-Fit Type: regular</span></p><p><span style="color: rgb(0, 0, 0);">-About the brand:- The John Jacobs collection features some of the most stylish and trendy sunglasses for men and women. Available in a variety of colours and shapes, it ensures you always stand out with your unique style.</span></p><p><span style="color: rgb(0, 0, 0);">-Frame pattern :- Featuring Grey Full Rim Hexagonal made from Polycarbonate which is thinner and lighter than normal plastic making them ideal for For Men and Women.</span></p><p><span style="color: rgb(0, 0, 0);">-Frame size: Small | Frame width: 128 mm | Frame Height: 43 mm | Frame Dimensions: (51-18-140)mm.</span></p>',
                'brand_id' => 11,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 82.0,
                'max_price' => 82.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 60,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/john_jacobs_uni_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:14:14',
                'updated_at' => '2023-09-27 05:14:14',
                'deleted_at' => null,
            ],
            86 => [
                'id' => 87,
                'name' => 'Men Blacck Polarised & UV Protected Lens Rectangle Sunglasses',
                'slug' => 'men-blacck-polarised-uv-protected-lens-rectangle-sunglasses-tfufk',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Frame Material: Metal || Sunglasses for Men || Velocity Sunglasses || Lens Material Type: - Polycarbonate</span></p><p><span style="color: rgb(0, 0, 0);">-Lens Color: Black || Item Shape: - Rectangular Sunglasses For Men</span></p><p><span style="color: rgb(0, 0, 0);">-Apart from keeping all that sunshine from wreaking havoc on your eyes, wearing the right shades just make you look cooler. Velocity Shades should be comfortable, stylish and offer top protection. Velocity sunglasses are designed to keep your eyes protected from UV, and make you look stylish while doing it.</span></p>',
                'brand_id' => 12,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 85.0,
                'max_price' => 85.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/men_black_polarised_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:15:22',
                'updated_at' => '2023-09-27 05:15:22',
                'deleted_at' => null,
            ],
            87 => [
                'id' => 88,
                'name' => 'Unnstructured Reflective Lightweight Breathable Stylish Sports Soft Hat Cap for Men and Women',
                'slug' => 'unnstructured-reflective-lightweight-breathable-stylish-sports-soft-hat-cap-for-men-and-women-g2d5f',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">-Care Instructions: Hand Wash Only</span></p><p><span style="color: rgb(0, 0, 0);">-Fit Type: Regular</span></p><p><span style="color: rgb(0, 0, 0);">-Breathable design</span></p><p><span style="color: rgb(0, 0, 0);">-Quick drying &amp; moisture-wicking</span></p><p><span style="color: rgb(0, 0, 0);">-Make an awesome gift</span></p><p><span style="color: rgb(0, 0, 0);">-Safety reflector belt</span></p><p><span style="color: rgb(0, 0, 0);"></span> </p>',
                'brand_id' => 2,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 74.0,
                'max_price' => 74.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 90,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/unstructured_reflective_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:16:50',
                'updated_at' => '2023-09-27 05:16:50',
                'deleted_at' => null,
            ],
            88 => [
                'id' => 89,
                'name' => 'Buccket Hat for Women Foldable Cotton Sun Beach Hat Fisherman Hat Casual Outdoor Cap Lovely Bomber Hats for Women Men Boy Girl',
                'slug' => 'buccket-hat-for-women-foldable-cotton-sun-beach-hat-fisherman-hat-casual-outdoor-cap-lovely-bomber-hats-for-women-men-boy-girl-chtmf',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Care Instructions: Hand Wash Only</span></p><p><span style="color: rgb(0, 0, 0);">-Fit Type: Stretch</span></p><p><span style="color: rgb(0, 0, 0);">-Material: Made from cotton rich fabric with ventilation holes, perfect for daily activities under sunlight. Durable and not easy to fade or break down. Soft and comfortable to wear;</span></p><p><span style="color: rgb(0, 0, 0);">-Protect the head from UV: Prevent you from UV when going out for sports or taking vacations. Great for beach vacation or fishing, hiking. Enjoy the outdoors in comfort and style;</span></p><p><span style="color: rgb(0, 0, 0);">-Modern and fashion design: The women bucket hats can be worn in 2 ways. Classic and stylish, show understate personality and your own style. Easily go well with various hairstyles or outfits, making you stand out in the crowds;</span></p>',
                'brand_id' => 3,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 56.0,
                'max_price' => 56.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/bucket_hat_for_women_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:18:00',
                'updated_at' => '2023-09-27 05:18:00',
                'deleted_at' => null,
            ],
            89 => [
                'id' => 90,
                'name' => 'Suun Hat  for Women Wide Brim Sun Visor Cap UV Protection Caps for Summer  Women Stylish',
                'slug' => 'suun-hat-for-women-wide-brim-sun-visor-cap-uv-protection-caps-for-summer-women-stylish-zruly',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Care Instructions: Hand Wash Only</span></p><p><span style="color: rgb(0, 0, 0);">-Fit Type: Adjustable</span></p><p><span style="color: rgb(0, 0, 0);">-Great material: Sunscreen fabric: The cap for women which is waterproof,breathable,quick-drying and environmentally friendly.</span></p><p><span style="color: rgb(0, 0, 0);">-Hat brim - Extra widened enlarged: Enlarged brim and larger shadow area provide you with more comprehensive sunscreen protection.</span></p><p><span style="color: rgb(0, 0, 0);">-Inner lining - Thermal insulation: Cap for summer women with the inner layer has breathable mesh,sweat-wicking, moisture-absorbing,and heat-insulating.</span></p>',
                'brand_id' => 1,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 63.0,
                'max_price' => 63.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/accessories_and_fashion_items/sun_hat_for_women_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:19:19',
                'updated_at' => '2023-09-27 05:19:19',
                'deleted_at' => null,
            ],
            90 => [
                'id' => 91,
                'name' => 'Neectar Valley Jojoba Essential Oil, 100% Natural Aromatherapy Oil For Hair, Skin, Face Care',
                'slug' => 'neectar-valley-jojoba-essential-oil-100-natural-aromatherapy-oil-for-hair-skin-face-care-mctxn',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Features:</span></p><p><span style="color: rgb(0, 0, 0);">-100% pure and natural jojoba oil with a variety of benefits</span></p><p><span style="color: rgb(0, 0, 0);">-Helps control excessive oil build-up on the skin and brightens dull skin</span></p><p><span style="color: rgb(0, 0, 0);">-Rich in vitamins B-complex and E, helps in skin repair and damage control</span></p><p><span style="color: rgb(0, 0, 0);">-Boosts hair growth as it nourishes the hair with vitamins C, E, B, copper and zinc</span></p><p><span style="color: rgb(0, 0, 0);">-Helps speed up the regeneration of skin cells for firm and smooth skin</span></p><p><span style="color: rgb(0, 0, 0);">-Works well as a beard oil for grooming your beard and as a pre-shave oil</span></p><p><span style="color: rgb(0, 0, 0);">-Container is a high quality amber glass bottle that doesn\'t allow oil to get oxidised by light</span></p><p><span style="color: rgb(0, 0, 0);">-Free from additives, chemicals, alcohol, fragrance and not diluted</span></p>',
                'brand_id' => 1,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 35.0,
                'max_price' => 60.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 80,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/nectar_valley_jojoba_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:21:46',
                'updated_at' => '2023-09-27 05:21:46',
                'deleted_at' => null,
            ],
            91 => [
                'id' => 92,
                'name' => 'Aroomahpure Fragrance Oil | Lavender Aroma Oil for Home Fragrance | Best for Aromatherapy | Helps in concentration & meditation | Used in Diffusers, Candles, Air Fresheners, Soaps.',
                'slug' => 'aroomahpure-fragrance-oil-lavender-aroma-oil-for-home-fragrance-best-for-aromatherapy-helps-in-concentration-meditation-used-in-diffusers-candles-air-fresheners-soaps-5aqy3',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Package Contains: Aromahpure Lavender Fragrance Oil (15ml)</span></p><p><span style="color: rgb(0, 0, 0);">-Lavender Fragrance: Get the joyful aroma of lavender that has a delicate, sweet smell that is also floral, herbal, and evergreen woody at the same time. Comes with soft, powdery, or smokey notes.</span></p><p><span style="color: rgb(0, 0, 0);">-Long Lasting Fragrance: Aromahpure Lavender Diffuser Oil is best known for its long lasting Fragrance. The Fragrances are enriched with the finest raw materials that ensures a long – lasting effect which makes these fragrances the most beloved fragrances around the world. They are also used as an oil diffuser for home fragrance &amp; as a candle fragrance oil.</span></p><p><span style="color: rgb(0, 0, 0);">-Long Lasting Fragrance: The Aromahpure Rosemary Fragrance Oil is best known for it\'s long lasting Fragrance. The Essential oils used in these Fragrances are the most beloved fragrances around the world. These Essential Oil are also used as an oil diffuser for home fragrance &amp; as a candle fragrance oil.</span></p>',
                'brand_id' => 2,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 30.0,
                'max_price' => 35.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 80,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/aromahpure_fragrance_oil_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:23:53',
                'updated_at' => '2023-09-27 05:23:53',
                'deleted_at' => null,
            ],
            92 => [
                'id' => 93,
                'name' => 'Arooma Essential Oil Fragrance Oils For Diffusers, Home Care, Candle Making, Fragrance, Aromatherapy, Humidifiers (Lavender+Sandal+LemonGrass+TeaTree+PinkRose+Orchid)',
                'slug' => 'arooma-essential-oil-fragrance-oils-for-diffusers-home-care-candle-making-fragrance-aromatherapy-humidifiers-lavendersandallemongrassteatreepinkroseorchid-eozjn',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Fregranto essential oils are suitable for aromatherapy diffuser and have many other great uses and benefits. Add a few drops of Fregranto Essential Oil into a diffuser or oil burner to promote relaxation and relieve stress.</span></p><p><span style="color: rgb(0, 0, 0);">-Our Aroma Fragrance Oils are formulated to be suitable for creating your own candles, soaps, air freshener spray, skin and hair care formulations, cleaning products, for use in home aroma diffusers, scented dryer sheets, freshen a drawer, potpourri, freshen carpets, massage/body oil, sugar scrubs, fragrance oil for candle making and many more. Personalize any of your unscented products.</span></p>',
                'brand_id' => 2,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 59.0,
                'max_price' => 59.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/aroma_essential_oil_fragranc_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:25:47',
                'updated_at' => '2023-09-27 05:25:47',
                'deleted_at' => null,
            ],
            93 => [
                'id' => 94,
                'name' => 'Organic Rosemary Essential Oil 100% Pure Oil for Hair Growth',
                'slug' => 'organic-rosemary-essential-oil-100-pure-oil-for-hair-growth-vfphg',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Features:</span></p><p><span style="color: rgb(0, 0, 0);">-100% pure and natural therapeutic grade rosemary oil</span></p><p><span style="color: rgb(0, 0, 0);">-Promotes hair growth and reduces dandruff</span></p><p><span style="color: rgb(0, 0, 0);">-Nourishes hair and stimulates hair growth</span></p><p><span style="color: rgb(0, 0, 0);">-Excudes a fresh, cooling and herbaceous aroma</span></p><p><span style="color: rgb(0, 0, 0);">-Alleviates headaches, fights anxiety and stress</span></p><p><span style="color: rgb(0, 0, 0);">-Cruelty free and non GMO</span></p>',
                'brand_id' => 1,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 60.0,
                'max_price' => 70.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/organic_rosemary_essential_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:27:35',
                'updated_at' => '2023-09-27 05:27:35',
                'deleted_at' => null,
            ],
            94 => [
                'id' => 95,
                'name' => 'Genttlemen\'s Crew Argan & Tea Tree Ultra Growth Beard Oil',
                'slug' => 'genttlemens-crew-argan-tea-tree-ultra-growth-beard-oil-i0lbu',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">How to apply</span></p><p><span style="color: rgb(0, 0, 0);">-Wash and cleanse your beard</span></p><p><span style="color: rgb(0, 0, 0);">-Dispense 2-3 drops of the oil and rub between your palms</span></p><p><span style="color: rgb(0, 0, 0);">-Massage upwards from root to tip, working the oil into the skin</span></p><p><span style="color: rgb(0, 0, 0);">-Use your comb or fingers to evenly distribute the oil</span></p>',
                'brand_id' => 8,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 120.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 70,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/gentlemens_crew_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:29:52',
                'updated_at' => '2023-09-27 05:29:52',
                'deleted_at' => null,
            ],
            95 => [
                'id' => 96,
                'name' => 'Arrgan & Geranium Beard Oil',
                'slug' => 'arrgan-geranium-beard-oil-wczmt',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Argan, often called ‘liquid gold’, is proven to make hair softer, silkier and shinier.</span></p><p><span style="color: rgb(0, 0, 0);">-Tame beard frizz naturally with this specially formulated blend of Moroccan Argan oil and Geranium, packed with anti-oxidants.</span></p><p><span style="color: rgb(0, 0, 0);">-This oil instantly enhances manageability, shine and ensures long-lasting conditioning.</span></p><p><span style="color: rgb(0, 0, 0);">-The rejuvenating fragrance of geranium is a relaxant, and its anti-bacterial and anti-microbial properties also ensure healthy hair growth.</span></p><p><span style="color: rgb(0, 0, 0);">-All of The Man Company’s products are SLS and Paraben free, with no chemical additives.</span></p>',
                'brand_id' => 9,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 20.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 60,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/argan_geranium_beard_oil_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:32:05',
                'updated_at' => '2023-09-27 05:32:05',
                'deleted_at' => null,
            ],
            96 => [
                'id' => 97,
                'name' => 'Peelgrim Redensyl & Anagain Advanced Hair Growth Serum',
                'slug' => 'peelgrim-redensyl-anagain-advanced-hair-growth-serum-yqmtj',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Benefits:</span></p><p><span style="color: rgb(0, 0, 0);">-92% observed new hair growth</span></p><p><span style="color: rgb(0, 0, 0);">-88% saw a reduction in hair fall</span></p><p><span style="color: rgb(0, 0, 0);">-85% felt an increment in hair density &amp; thickness</span></p><p><span style="color: rgb(0, 0, 0);">*Based on consumer feedback after 6 weeks of recommended usage</span></p><p><br></p>',
                'brand_id' => 10,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 93.0,
                'max_price' => 93.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/pilgrim_redensyl_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:33:52',
                'updated_at' => '2023-09-27 05:33:52',
                'deleted_at' => null,
            ],
            97 => [
                'id' => 98,
                'name' => 'Hair Reppair Spa Kit - (Hair Repair Shampoo + Hair Repair Spa Cream + Hair Repair Serum)',
                'slug' => 'hair-reppair-spa-kit-hair-repair-shampoo-hair-repair-spa-cream-hair-repair-serum-m6ah8',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Hair Repair Spa Kit is a 3 Step Hair Repair and Damage Control Spa Kit which Includes Step 1 - 250g Hair Repair Shampoo Step 2 - 250g Hair Repair Spa Cream and Step 3 - 50ml Hair Repair Serum</span></p><p><span style="color: rgb(0, 0, 0);">-This Hair Spa Kit helps to reconstructs and strengthens extremely damaged and fragile hair. It is known to improve the tensile strength of damaged hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Barley Hair Repair Spa Cream is enriched with the goodness of Hydrolyzed Keratin Powder, Shea Butter and Argan Oil, this hair spa cream penetrates deeply into the Scalp architecture to re-cement the Cell-Membrane-Complex, the intercellular bonding cement responsible for strong and flexible hair fiber.</span></p>',
                'brand_id' => 11,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 50.0,
                'max_price' => 90.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/hair_repair_spa_kit_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:35:33',
                'updated_at' => '2023-09-27 05:35:33',
                'deleted_at' => null,
            ],
            98 => [
                'id' => 99,
                'name' => 'Dot & Key I-Beauty Watermelon Essentials Combo',
                'slug' => 'dot-key-i-beauty-watermelon-essentials-combo-3eoqk',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Instantly cools &amp; hydrates skin</span></p><p><span style="color: rgb(0, 0, 0);">-Blocks UVA, UVB, Blue Light &amp; IR rays</span></p><p><span style="color: rgb(0, 0, 0);">-Lightweight gel cream texture</span></p><p><span style="color: rgb(0, 0, 0);">-Prevents sunburn &amp; tanning</span></p><p><span style="color: rgb(0, 0, 0);">-Provides better Vitamin D absorption</span></p>',
                'brand_id' => 12,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 90.0,
                'max_price' => 90.0,
                'discount_value' => 3.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1696118400,
                'discount_end_date' => 1701302400,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/dot_key_i_beauty_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:37:21',
                'updated_at' => '2023-09-27 05:37:21',
                'deleted_at' => null,
            ],
            99 => [
                'id' => 100,
                'name' => 'Kerratin Hair Spa Treatment, Beauty Real Make Your Hair More Smooth, Real Hair Spa Repairing Cream Bath for Damaged Hair',
                'slug' => 'kerratin-hair-spa-treatment-beauty-real-make-your-hair-more-smooth-real-hair-spa-repairing-cream-bath-for-damaged-hair-7vww4',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">-Quality Treatment : Revitalizing &amp; rejuvenating your dry &amp; damaged hair, the keratin treatment does wonders to your hair. The calming and relaxing treatment soothe your hair and its ultimate health. Add volume &amp; shine to your hair giving back the beautiful look.</span></p><p><span style="color: rgb(0, 0, 0);">-Overall Improvement : Helps reduce frizz, provides shine, volume &amp; manageability to hair retains moisture, and helps to get rid of split ends. With nourishment to the roots, it revitalizes the scalp, balancing the natural hair growth.</span></p><p><span style="color: rgb(0, 0, 0);">-Recommended by Professionals : Recommended by professional stylists for all types of treatment with Keratin, which is a natural source of Vitamin E, provides luxurious shine, lush softness, and no residue. This is a personal rescue mission for your dry hair.</span></p><p><span style="color: rgb(0, 0, 0);">-The brand endeavors to offer a premium collection of skin &amp; hair care products &amp; accessories creatively crafted with genuine &amp; natural ingredients for a fine and rejuvenated spirit, in and out.</span> </p>',
                'brand_id' => 12,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 30.0,
                'max_price' => 80.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 20,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/keratin_hair_spa_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:39:28',
                'updated_at' => '2023-09-27 05:39:28',
                'deleted_at' => null,
            ],
            100 => [
                'id' => 101,
                'name' => 'mCaaffeine Deep Conditioning Hair Mask for Smoothening Hair | Hair Spa Cream with Shea Butter & Murumuru Butter | Hair Mask For Frizzy, Dry & Damaged Hair | SLS & Paraben Free',
                'slug' => 'mcaaffeine-deep-conditioning-hair-mask-for-smoothening-hair-hair-spa-cream-with-shea-butter-murumuru-butter-hair-mask-for-frizzy-dry-damaged-hair-sls-paraben-free-bmhl1',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-Intense hair damage repair, deep conditioning, hair moisture replenishment: A hair mask to unmask conditioned &amp; nourished hair! Users experienced 10X stronger hair with the regular use of Latte Coffee Hair Mask when compared to a neutral product. This mask has a rich creamy texture &amp; exudes an aroma of smooth buttery flavours blended with delicate notes of coffee.</span></p><p><span style="color: rgb(0, 0, 0);">-Coffee-infused hair care with the goodness of milk: Coffee is not just a refreshing drink to get your day started. It\'s much more than that. It is a superfood for the hair and has numerous benefits. Coffee is also a rich source of Caffeine. Coffee &amp; Caffeine repair damaged hair and add natural shine. They also strengthen hair and control hair fall. This mask is also packed with Coconut Milk that replenishes moisture and adds natural shine to hair.</span></p><p><span style="color: rgb(0, 0, 0);">-Just good, nothing bad: Our mission is to get you Addicted To Good and get you off of all the bad. Latte Coffee Hair Mask is free from harmful chemicals, SLS, Paraben, Mineral Oil and everything that can be bad for your hair.</span></p>',
                'brand_id' => 4,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 35.0,
                'max_price' => 50.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/home_spa_and_self_care_kits/mcaffeine_deep_conditioning_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:41:15',
                'updated_at' => '2023-09-27 05:41:15',
                'deleted_at' => null,
            ],
            101 => [
                'id' => 102,
                'name' => 'Feces Caanada Ultime Pro Splash Mini Nail Enamel Combo - Tropical Twilight(Combo is a Pack of 4)',
                'slug' => 'feces-caanada-ultime-pro-splash-mini-nail-enamel-combo-tropical-twilightcombo-is-a-pack-of-4-vw1na',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-These Splash Mini Combo is a Pack of 4 of 4 beautiful shades; Floral Dream, Royal Ruby, Cherry Blast, Watermelon.</span></p><p><span style="color: rgb(0, 0, 0);">Key Benefits:</span></p><p><span style="color: rgb(0, 0, 0);">-Limited edition: FACES CANADA Ultime Pro Splash Enamel is now launched in 10 exclusive shades that are specially curated for your Wedding and Party looks.</span></p><p><span style="color: rgb(0, 0, 0);">-High-shine: These Nail Enamels are tiny but power-packed High Sine Enamels that are meant to lend a super gorgeous finish to your look.</span></p><p><span style="color: rgb(0, 0, 0);">-Quick-drying: These Nail Enamels will take no time to dry so you can rock that party a little sooner than you were.</span></p><p><span style="color: rgb(0, 0, 0);">-Chip-defiant: The Nail Enamels are formulated with a unique chip-resistant technology so that you can be carefree when it comes to enjoying any party!</span></p>',
                'brand_id' => 10,
                'unit_id' => 4,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 100.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/faces_canada_ultime_pro_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:43:41',
                'updated_at' => '2023-09-27 05:43:41',
                'deleted_at' => null,
            ],
            102 => [
                'id' => 103,
                'name' => 'Polly Nail Gel Extension Kit With Slip Solution Uv Nail Lamp for Builder Gel UV Nail Art Kit Nail Extension Set.',
                'slug' => 'polly-nail-gel-extension-kit-with-slip-solution-uv-nail-lamp-for-builder-gel-uv-nail-art-kit-nail-extension-set-qtv0d',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">-All-In-One Poly Gel Kit: Our THR3E STROKES Poly Nail Gel Kit contains nail extension Poly gel, a nail lamp, 100pcs dual nail forms, a slip solution, and other nail tools.</span></p><p><span style="color: rgb(0, 0, 0);">-Portable and Functional LED Nail Lamp: Our nail lamp is compact and efficient with 6 light beads which are convenient for applying poly gel and quick-dry!</span></p><p><span style="color: rgb(0, 0, 0);">-Healthy＆Long-Lasting poly gel kit: Our Poly nail gel is non-toxic and has a low odor which is healthy and has no harm to your natural nails.</span></p><p><span style="color: rgb(0, 0, 0);">-The nail poly gel is easy-to-apply, which keeps your charming poly gel nails for 3 weeks. Slip solution can help you get the poly gel out of the bottle conveniently and is amazing for correcting mistakes before curing.</span></p>',
                'brand_id' => 13,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 75.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 100,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/thr3e_strokes_poly_nail_gel_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:45:08',
                'updated_at' => '2023-09-27 05:45:08',
                'deleted_at' => null,
            ],
            103 => [
                'id' => 104,
                'name' => 'Faremacy Beauty Healthy Skin Starter Kit (Cleansing Balm + 2% BHA Toner + Night Serum + Moisturizer)',
                'slug' => 'faremacy-beauty-healthy-skin-starter-kit-cleansing-balm-2-bha-toner-night-serum-moisturizer-zscqw',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Benefits:</span></p><p><span style="color: rgb(0, 0, 0);">-Everything you need to glow! The skincare starter kit includes a 4-step skincare regimen for clean, hydrated + glowing skin.</span></p><p><span style="color: rgb(0, 0, 0);">-Purifying cleansing balm. Best-selling Green Clean gently + effortlessly removes sunscreen residue, makeup + excess oil, plus it gently exfoliates-all without stripping skin!</span></p><p><span style="color: rgb(0, 0, 0);">-Exfoliating + deep-cleaning toner. Deep Sweep gently exfoliates with 2% BHA + papaya enzymes, helping to minimize the look of pores + draw out excess oil to help reduce shine.</span></p><p><span style="color: rgb(0, 0, 0);">-Resurfacing night serum. Formulated with a 14% AHA/BHA/gentle flower acids blend, Honeymoon Glow resurfaces dull skin, exfoliates + helps reduce the appearance of fine lines and wrinkles.</span></p><p><span style="color: rgb(0, 0, 0);">-Plumping + renewing moisturizer. Honey Halo replenishes the skin barrier, locks in moisture + visibly improves the look of fine lines with potent plant-based ceramides, buckwheat honey, shea butter + vitamin E.</span></p>',
                'brand_id' => 13,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 96.0,
                'max_price' => 96.0,
                'discount_value' => 3.0,
                'discount_type' => 'percent',
                'discount_start_date' => 1696118400,
                'discount_end_date' => 1698710400,
                'sell_target' => 0,
                'stock_qty' => 10,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/farmacy_beauty_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:46:58',
                'updated_at' => '2023-09-27 05:46:58',
                'deleted_at' => null,
            ],
            104 => [
                'id' => 105,
                'name' => 'Lip Care Set (Grapefruit Lip Glowy Balm And Berry Lip Sleeping Mask)',
                'slug' => 'lip-care-set-grapefruit-lip-glowy-balm-and-berry-lip-sleeping-mask-6dxca',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Lip Care Set includes a Lip Glowy Balm and a Lip Sleeping Mask.</span></p><p><span style="color: rgb(0, 0, 0);">*The set contents:</span></p><p><span style="color: rgb(0, 0, 0);">-3 x LANEIGE Lip Sleeping Mask(3g): LANEIGE\'s cult favourite Lip Sleeping Mask helps dissolve dead skin cells and moisturize your lips while you sleep.</span></p><p><span style="color: rgb(0, 0, 0);">-1 x LANEIGE Lip Glowy Lip Balm - Grapefruit (10g): LANEIGE Grapefruit Glowy Lip balm coats the lips with a layer of moisture and makes them look supple and glossy. Daily moisturizing: It instantly removes flakes and makes the lips look hydrated as though the lips are coated with a breathable layer of moisture. Texture that\'s smoothly wrapping the lips: It applies as though it\'s wrapping the lips with colorless thin layers, so the lips feel light, while still not damaging the color of the lipstick. For a healthy voluptuous look of the lips: It adds a natural healthy color to make the lips look full, voluptuous.</span></p>',
                'brand_id' => 10,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 93.0,
                'max_price' => 93.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/lip_care_set_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:48:09',
                'updated_at' => '2023-09-27 05:48:09',
                'deleted_at' => null,
            ],
            105 => [
                'id' => 106,
                'name' => 'Haiir essentials combo of 3',
                'slug' => 'haiir-essentials-combo-of-3-jwzvp',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Riyoerbs Sulphate Free Shampoo is a unique formula that not only cleanses the scalp but also repairs your frizzy, damaged hair &amp; split ends. The sulphate free formula makes it ideal for very sensitised, colour treated or chemically treated hair. After washing it will leave your hair less frizzy, more manageable, detangled and protected &amp; protected.</span></p><p><span style="color: rgb(0, 0, 0);">Riyoherbs Hair Conditioner is a unique formula that not only gives silky, smooth, frizz-free hair but also nourishes it with the goodness of natural keratin protein and advanced botox repair technology, leaving your hair softer, easier to manage and lustrous.</span></p><p><span style="color: rgb(0, 0, 0);">Riyoherbs Smoothing Argan Oil Hair Mask is a professionally designed formula that efficiently penetrates into the hair cuticle and starts repairing &amp; restoring damaged hair from inside out. It deeply nourishes and moisturizes every strand giving you detangled, frizz free &amp; glossy hair. Get a hair spa feeling at home after one use.</span></p>',
                'brand_id' => 3,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 75.0,
                'max_price' => 75.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 30,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/hair_essentials_combo_of_3_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:49:26',
                'updated_at' => '2023-09-27 05:49:26',
                'deleted_at' => null,
            ],
            106 => [
                'id' => 107,
                'name' => 'Riice water and lavender hair care kit(Shampoo + Conditioner)',
                'slug' => 'riice-water-and-lavender-hair-care-kitshampoo-conditioner-jrwtb',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">Rice water shampoo by WOW Skin Science infused with rice water and rice keratin protein is just the product to help you get the hair of your dreams. It rejuvenate your damaged hair and weak, irritated scalp with the deeply nourishing goodness.</span></p><p><span style="color: rgb(0, 0, 0);">Rice water conditioner by WOW Skin Science infused with rice water, rice keratin protein and lavender essential oil is just the product to help you get the hair of your dreams. The actives help to strengthen strands, smoothen cuticles and boost shine.</span></p>',
                'brand_id' => 4,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 68.0,
                'max_price' => 68.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/rice_water_and_lavender_hair_care_kit_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:50:53',
                'updated_at' => '2023-09-27 05:50:53',
                'deleted_at' => null,
            ],
            107 => [
                'id' => 108,
                'name' => 'Ignnis Shampoo & Conditioner hair care duo',
                'slug' => 'ignnis-shampoo-conditioner-hair-care-duo-bzyp3',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">Enriched with nourishing ingredients this set of shampoo &amp; conditioner gently removes dirt &amp; oil and strengthens hair follicles leaving them soft and silky. The calming notes of Bergamot &amp; Tea Tree help you relax while you indulge in a Vegan hair care.</span> </p>',
                'brand_id' => 5,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 59.0,
                'max_price' => 59.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/Ignis_Shampoo_Conditioner_hair_care_duo_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:52:03',
                'updated_at' => '2023-09-27 05:52:03',
                'deleted_at' => null,
            ],
            108 => [
                'id' => 109,
                'name' => 'MCaffeine Coffee Quick Glow-up Body Gift Kit - Tan Removal Body Mask & Hydrating Body Serum',
                'slug' => 'mcaffeine-coffee-quick-glow-up-body-gift-kit-tan-removal-body-mask-hydrating-body-serum-bpzuz',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">The Good We Are</span></p><p><span style="color: rgb(0, 0, 0);">-Peta Certified Vegan</span></p><p><span style="color: rgb(0, 0, 0);">-Free From Beeswax</span></p><p><span style="color: rgb(0, 0, 0);">-ade Safe</span></p><p><span style="color: rgb(0, 0, 0);">-FDA-approved</span></p><p><span style="color: rgb(0, 0, 0);">-Dermatologically-tested</span></p><p><span style="color: rgb(0, 0, 0);">-Gender-neutral</span></p><p><span style="color: rgb(0, 0, 0);">-Inclusive</span></p>',
                'brand_id' => 4,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 90.0,
                'max_price' => 90.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/mcaffeine_coffee_quick_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:54:08',
                'updated_at' => '2023-09-27 05:54:08',
                'deleted_at' => null,
            ],
            109 => [
                'id' => 110,
                'name' => 'Keemirica Love Story Luxury Gift Box Body Wash Body Lotion & Bathing Bar',
                'slug' => 'keemirica-love-story-luxury-gift-box-body-wash-body-lotion-bathing-bar-5vqdw',
                'short_description' => null,
                'description' => '<p><span style="color: rgb(0, 0, 0);">*What\'s Inside?</span></p><p><span style="color: rgb(0, 0, 0);">-Clear bathing bar</span></p><p><span style="color: rgb(0, 0, 0);">-Creamy bathing bar</span></p><p><span style="color: rgb(0, 0, 0);">-Love story body wash</span></p><p><span style="color: rgb(0, 0, 0);">-Love stary body lotion</span></p><p><span style="color: rgb(0, 0, 0);">*Made with love</span></p><p><span style="color: rgb(0, 0, 0);">-Shea Butter &amp; Jojoba</span></p><p><span style="color: rgb(0, 0, 0);">-Ginkgo Biloba &amp; White Tea Extract</span></p><p><span style="color: rgb(0, 0, 0);">-Aloe Vera</span></p><p><span style="color: rgb(0, 0, 0);">-Vitamin E</span> </p>',
                'brand_id' => 5,
                'unit_id' => null,
                'product_tags' => null,
                'min_price' => 89.0,
                'max_price' => 89.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 50,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 0,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/kimirica_love_story_luxury_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:57:22',
                'updated_at' => '2023-09-27 05:57:22',
                'deleted_at' => null,
            ],
            110 => [
                'id' => 111,
                'name' => 'BoddyHerbals Rose Bath And Body Spa Kit - Gift Sets & Combos for Women & Men',
                'slug' => 'boddyherbals-rose-bath-and-body-spa-kit-gift-sets-combos-for-women-men-8htl0',
                'short_description' => null,
                'description' => '<p> <span style="color: rgb(0, 0, 0);">The gift set contains:</span></p><p><span style="color: rgb(0, 0, 0);">-BodyHerbals Rose Shower Gel (200 ml):Feed your skin with this shower gel, it is enriched with natural rose, aloe vera, sea buckthorn and many other herbs to cleanse and moisturize skin. Let this shower gel envelope your skin with the silky soft foam, while its invigorating scent of rose stimulates your senses. It has lingering fragrance which will stay on the body for hours.</span></p><p><span style="color: rgb(0, 0, 0);">-BodyHerbals Rose Essential Oil Potpourri:Indulge in a complete spa ambience with this fragranced rose potpourri.</span></p><p><span style="color: rgb(0, 0, 0);">-Luxury Shower Cap:This shower cap protects your hair from getting wet in the shower.</span></p><p><span style="color: rgb(0, 0, 0);">-Terry Towel:The towel is made of terry cotton material. It absorbs water easily.</span></p><p><span style="color: rgb(0, 0, 0);">-Diffuser:Perfect to create an aromatic experience in the comfort of your home.</span></p><p><span style="color: rgb(0, 0, 0);">-Tea-Light Candles x 2:These fragranced tea light candles have a soothing aroma.</span></p><p><span style="color: rgb(0, 0, 0);">-Loofah:A high quality exfoliator that helps to slough off tan and dead skin.</span></p>',
                'brand_id' => 5,
                'unit_id' => 1,
                'product_tags' => null,
                'min_price' => 80.0,
                'max_price' => 150.0,
                'discount_value' => 0.0,
                'discount_type' => 'percent',
                'discount_start_date' => null,
                'discount_end_date' => null,
                'sell_target' => 0,
                'stock_qty' => 15,
                'status' => 1,
                'is_featured' => 1,
                'min_purchase_qty' => 1,
                'max_purchase_qty' => 1,
                'has_variation' => 1,
                'has_warranty' => 1,
                'total_sale_count' => 0.0,
                'standard_delivery_hours' => 72,
                'express_delivery_hours' => 24,
                'size_guide' => null,
                'reward_points' => 0,
                'feature_image' => public_path('/dummy-images/all_products/gift_sets_and_bundles/bodyherbals_rose_bath_1.png'),
                'updated_by' => 1,
                'deleted_by' => null,
                'created_by' => 1,
                'created_at' => '2023-09-27 05:59:06',
                'updated_at' => '2023-09-27 05:59:06',
                'deleted_at' => null,
            ],
        ];

        foreach ($data as $key => $val) {
            $featureImage = $val['feature_image'] ?? null;
            $productData = Arr::except($val, ['feature_image']);
            $product = Product::create($productData);
            if (isset($featureImage)) {
                $this->attachFeatureImage($product, $featureImage);
            }
        }
    }

    private function attachFeatureImage($model, $publicPath)
    {
        if (! env('IS_DUMMY_DATA_IMAGE')) {
            return false;
        }

        $file = new \Illuminate\Http\File($publicPath);

        $media = $model->addMedia($file)->preservingOriginal()->toMediaCollection('feature_image');

        return $media;
    }
}
