<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Modules\Employee\Models\EmployeeRating;

class ReviewsExport implements FromCollection, WithHeadings
{
    public array $columns;

    public array $dateRange;

    public function __construct($columns, $dateRange)
    {
        $this->columns = $columns;
        $this->dateRange = $dateRange;
    }

    public function headings(): array
    {
        $modifiedHeadings = [];

        foreach ($this->columns as $column) {
            // Capitalize each word and replace underscores with spaces
            $modifiedHeadings[] = ucwords(str_replace('_', ' ', $column));
        }

        return $modifiedHeadings;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $query = EmployeeRating::with('user', 'employee');

        $query->whereDate('created_at', '>=', $this->dateRange[0]);

        $query->whereDate('created_at', '<=', $this->dateRange[1]);

        $query->orderBy('updated_at', 'desc');

        $query = $query->get();

        $newQuery = $query->map(function ($row) {
            $selectedData = [];

            foreach ($this->columns as $column) {
                switch ($column) {
                    case 'user_id':
                        $selectedData[$column] = isset($row->user->full_name) ? $row->user->full_name : '-';
                        break;

                    case 'employee_id':
                        $selectedData[$column] = isset($row->employee->full_name) ? $row->employee->full_name : '-';
                        break;

                    case 'updated_at':
                        $diff = timeAgoInt($row->updated_at);

                        if ($diff < 25) {
                            $selectedData[$column] = timeAgo($row->updated_at);
                        } else {
                            $selectedData[$column] = customDate($row->updated_at);
                        }
                        break;
                    default:
                        $selectedData[$column] = $row[$column];
                        break;
                }
            }

            return $selectedData;
        });

        return $newQuery;
    }
}
