<?php $__env->startSection('title'); ?>
    <?php echo e(__($module_title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .alternate-list {
            display: flex;
            flex-direction: column;
            margin-bottom: 0;
        }
        .alternate-list li:not(:last-child){
            padding-bottom: 1rem;
            margin-bottom: 1rem;
            border-bottom: 1px solid var(--bs-border-color);
        }
    </style>

<style type="text/css" media="print">
      @page :footer {
        display: none !important;
      }

      @page :header {
        display: none !important;
      }
      @page { size: landscape; }
      /* @page { margin: 0; } */

      .pr-hide {
        display: none;
        }

      button {
        display: none !important;
      }
      * {
        -webkit-print-color-adjust: none !important;   /* Chrome, Safari 6 – 15.3, Edge */
        color-adjust: none !important;                 /* Firefox 48 – 96 */
        print-color-adjust: none !important;           /* Firefox 97+, Safari 15.4+ */
      }
    </style>

    <div class="row pr-hide">
        <div class="col-12">
            <div class="card ">
                <div class="card-header border-bottom-0">
                    <div class="row pr-hide">
                        <div class="col-auto col-lg-4 mb-4">
                            <div class="input-group">
                                <select class="form-select select2" name="payment_status"
                                    data-minimum-results-for-search="Infinity" id="update_payment_status">
                                    <option value="" disabled>
                                        Payment Status
                                    </option>
                                    <option value="paid" <?php echo e($order->payment_status == 'paid' ? 'selected' : ''); ?>>
                                        Paid
                                    </option>
                                    <option value="unpaid" <?php echo e($order->payment_status == 'unpaid' ? 'selected' : ''); ?>>
                                        Unpaid
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-auto col-lg-4 mb-4">
                            <div class="input-group">
                                <select name="delivery_status" class="form-control select2" name="delivery_status"
                                    data-ajax--url="<?php echo e(route('backend.get_search_data', ['type' => 'constant', 'sub_type' => 'ORDER_STATUS'])); ?>"
                                    data-ajax--cache="true">
                                    <option value="" disabled>Delivery Status</option>
                                    <?php if(isset($order->delivery_status)): ?>
                                        <option value="<?php echo e($order->delivery_status); ?>" selected>
                                            <?php echo e(Str::title(Str::replace('_', ' ', $order->delivery_status))); ?>

                                        </option>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-auto col-lg-4 mb-4 text-center text-lg-end">
                            <a class="btn btn-primary" onclick="invoicePrint(this)">
                                <i class="fa-solid fa-download"></i>
                                Download Invoice
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!--Main Invoice-->
        <div class="col-xl-9 order-2 order-md-2 order-lg-2 order-xl-1">
            <div class="card mb-4" id="section-1">
                <div class="card-body">
                    <!--Order Detail-->
                    <div class="row justify-content-between align-items-center g-3 mb-4">
                        <div class="col-auto flex-grow-1">
                            <img src="<?php echo e(asset(setting('logo'))); ?>" alt="logo" class="img-fluid" width="200">
                        </div>
                        <div class="col-auto text-end">
                            <h5 class="mb-0">Invoice
                                <span
                                    class="text-accent"><?php echo e(setting('inv_prefix')); ?><?php echo e($order->orderGroup->order_code); ?>

                                </span>
                            </h5>
                            <span class="text-muted">Order Date:
                                <?php echo e(date('d M, Y', strtotime($order->created_at))); ?>

                            </span>
                            <?php if($order->location_id != null): ?>
                                <div>
                                    <span class="text-muted">
                                        <i class="las la-map-marker"></i> <?php echo e(optional($order->location)->name); ?>

                                    </span>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="d-flex justify-content-md-between justify-content-center g-3">
                        <div class="col-auto">
                            <!--Customer Detail-->
                            <div class="welcome-message">
                                <h5 class="mb-2">Customer Info</h6>
                                    <p class="mb-0">Name: <strong><?php echo e(optional($order->user)->full_name); ?></strong></p>
                                    <p class="mb-0">Email: <strong><?php echo e(optional($order->user)->email); ?></strong></p>
                                    <p class="mb-0">Phone: <strong><?php echo e(optional($order->user)->mobile); ?></strong></p>
                            </div>
                            <div class="col-auto mt-3">
                                <h6 class="d-inline-block">Payment Method: </h6>
                                <span class="badge bg-primary"><?php echo e(ucwords(str_replace('_', ' ', $order->orderGroup->payment_method))); ?></span>
                            </div>
                            <h6 class="col-auto d-inline-block">Logistic: </h6> <span class="badge bg-primary"><?php echo e($order->logistic_name); ?></span>
                        </div>
                        <div class="col-auto">
                            <div class="shipping-address d-flex justify-content-md-end gap-3 mb-3">
                                <div class="border-end w-25">
                                    <h5 class="mb-2">Shipping Address</h5>
                                        <?php
                                            $shippingAddress = $order->orderGroup->shippingAddress;
                                        ?>
                                        <p class="mb-0 text-wrap">
                                            <?php echo e(optional($shippingAddress)->address_line_1); ?>,
                                            <?php echo e(optional($shippingAddress->city_data)->name); ?>,
                                            <?php echo e(optional($shippingAddress->state_data)->name); ?>,
                                            <?php echo e(optional($shippingAddress->country_data)->name); ?>

                                        </p>
                                </div>
                                <?php if(!$order->orderGroup->is_pos_order): ?>
                                    <div class="w-25">
                                        <h5 class="mb-2">Billing Address</h5>
                                        <?php
                                            $billingAddress = $order->orderGroup->billingAddress;
                                        ?>
                                        <p class="mb-0 text-wrap">

                                            <?php echo e(optional($billingAddress)->address_line_1); ?>,
                                            <?php echo e(optional($billingAddress->city_data)->name); ?>,
                                            <?php echo e(optional($billingAddress->state_data)->name); ?>,
                                            <?php echo e(optional($billingAddress->country_data)->name); ?>

                                        </p>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <!-- <div class="shipping-address d-flex justify-content-md-end gap-3">
                                <div class="w-25"></div>
                                <div class="w-25">

                                </div>
                            </div> -->
                        </div>
                    </div>
                </div>

                <!--order details-->
                <table class="table table-bordered border-top" data-use-parent-width="true">
                    <thead>
                        <tr>
                            <th class="text-center" width="7%">S/L</th>
                            <th>Products</th>
                            <th>Unit Price</th>
                            <th>QTY</th>
                            <th class="text-end">Total Price</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $product = $item->product_variation->product;
                            ?>
                            <tr>
                                <td class="text-center"><?php echo e($key + 1); ?></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div> <img src="<?php echo e($product->feature_image); ?>" alt="<?php echo e($product->name); ?>"
                                                class="avatar avatar-50 rounded-pill">
                                        </div>
                                        <div class="ms-2">
                                            <h6 class="fs-sm mb-0">
                                                <?php echo e($product->name); ?>

                                            </h6>
                                            <div class="text-muted">
                                                <?php $__currentLoopData = generateVariationOptions($item->product_variation->combinations); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="fs-xs">
                                                        <?php echo e($variation['name']); ?>:
                                                        <?php $__currentLoopData = $variation['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php echo e($value['name']); ?>

                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!$loop->last): ?>
                                                            ,
                                                        <?php endif; ?>
                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                </td>

                                <td class="">
                                    <span class="fw-bold"><?php echo e(\Currency::format($item->unit_price)); ?>

                                    </span>
                                </td>
                                <td class="fw-bold"><?php echo e($item->qty); ?></td>

                                <td class=" text-end">
                                    <?php if($item->refundRequest && $item->refundRequest->refund_status == 'refunded'): ?>
                                        <span
                                            class="badge bg-soft-info rounded-pill text-capitalize"><?php echo e($item->refundRequest->refund_status); ?></span>
                                    <?php endif; ?>
                                    <span class="text-accent fw-bold"><?php echo e(\Currency::format($item->total_price)); ?>

                                    </span>

                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot class="text-end">
                        <tr>
                            <td colspan="4">
                                <h6 class="d-inline-block me-3">Sub Total: </h6>
                            </td>
                            <td width="10%">
                                <strong><?php echo e(\Currency::format($order->orderGroup->sub_total_amount)); ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <h6 class="d-inline-block me-3">Tips: </h6>
                            </td>
                            <td width="10%" class="text-end">
                                <strong><?php echo e(\Currency::format($order->orderGroup->total_tips_amount)); ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="4">
                                <h6 class="d-inline-block me-3">Shipping Cost: </h6>
                            </td>
                            <td width="10%" class="text-end">
                                <strong><?php echo e(\Currency::format($order->orderGroup->total_shipping_cost)); ?></strong></td>
                        </tr>
                        <?php if($order->orderGroup->total_coupon_discount_amount > 0): ?>
                            <tr>
                                <td colspan="4">
                                    <h6 class="d-inline-block me-3">Coupon Discount: </h6>
                                </td>
                                <td width="10%" class="text-end">
                                    <strong><?php echo e(\Currency::format($order->orderGroup->total_coupon_discount_amount)); ?></strong>
                                </td>
                            </tr>
                        <?php endif; ?>
                        <tr>
                            <td colspan="4">
                                <h6 class="d-inline-block me-3">Grand Total: </h6>
                            </td>
                            <td width="10%" class="text-end"><strong
                                    class="text-accent"><?php echo e(\Currency::format($order->orderGroup->grand_total_amount)); ?></strong>
                            </td>
                        </tr>
                    </tfoot>
                </table>

                <!--Note-->
                <div class="card-body">
                    <div class="card-footer border-top-0 px-4 py-4 rounded bg-soft-gray border border-2">
                        <p class="mb-0"><?php echo e(setting('spacial_note')); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!--Order Status-->
        <div class="col-xl-3 order-1 order-md-1 order-lg-1 order-xl-2 pr-hide">
            <div class="sticky-sidebar">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="card-title">Order Status</h5>
                    </div>
                    <div class="card-body">
                        <ul class="alternate-list list-unstyled">

                            <?php $__empty_1 = true; $__currentLoopData = $order->orderUpdates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderUpdate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li>
                                    <a class="<?php echo e($loop->first ? 'active' : ''); ?>">
                                        <?php echo e($orderUpdate->note); ?> <br> By
                                        <span class="text-capitalize"><?php echo e(optional($orderUpdate->user)->name); ?></span>
                                        at
                                        <?php echo e(date('d M, Y', strtotime($orderUpdate->created_at))); ?>.</a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <li>
                                    <a class="active">No logs found</a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        function invoicePrint() {
            window.print()
        }

        function updateStatusAjax(__this, url) {
            $.ajax({
                url: url,
                type: 'POST',
                dataType: 'json',
                data: {
                    order_id: <?php echo e($order->id); ?>,
                    status: __this.val(),
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(res) {
                    if (res.status) {
                        window.successSnackbar(res.message)
                        setTimeout(() => {
                            location.reload()
                        }, 100);
                    }
                }
            });
        }
        $('[name="payment_status"]').on('change', function() {
            if ($(this).val() !== '') {
                updateStatusAjax($(this), "<?php echo e(route('backend.orders.update_payment_status')); ?>")
            }
        })

        $('[name="delivery_status"]').on('change', function() {
            if ($(this).val() !== '') {
                updateStatusAjax($(this), "<?php echo e(route('backend.orders.update_delivery_status')); ?>")
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/frezka/Modules/Product/Resources/views/backend/order/show.blade.php ENDPATH**/ ?>