<?php $__env->startSection('title'); ?>
    <?php echo e(__($module_title)); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <style>
        .alternate-list {
            display: flex;
            flex-direction: column;
            margin-bottom: 0;
        }
        .alternate-list li:not(:last-child){
            padding-bottom: 1rem;
            margin-bottom: 1rem;
            border-bottom: 1px solid var(--bs-border-color);
        }
    </style>

<style type="text/css" media="print">
      @page :footer {
        display: none !important;
      }

      @page :header {
        display: none !important;
      }
      @page { size: landscape; }
      /* @page { margin: 0; } */

      .pr-hide {
        display: none;
        }

      button {
        display: none !important;
      }
      * {
        -webkit-print-color-adjust: none !important;   /* Chrome, Safari 6 – 15.3, Edge */
        color-adjust: none !important;                 /* Firefox 48 – 96 */
        print-color-adjust: none !important;           /* Firefox 97+, Safari 15.4+ */
      }
      .badge {
        font-size: 1rem;
        padding: 0;
      }
    </style>

    <div class="row pr-hide">
        <div class="col-12">
            <div class="card ">
                <div class="card-header border-bottom-0">
                    <div class="row pr-hide">
                        <div class="col-auto col-lg-12 mb-4 text-center text-lg-end">
                            <a class="btn btn-primary" onclick="invoicePrint(this)">
                                <i class="fa-solid fa-download"></i>
                                Download Invoice
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4">
        <!--Main Invoice-->
        <div class="col-xl-12 order-2 order-md-2 order-lg-2 order-xl-1">
            <div class="card mb-4" id="section-1">
                <div class="card-body">
                    <!--Order Detail-->
                    <div class="row justify-content-between align-items-center g-3 mb-4">
                        <div class="col-auto flex-grow-1">
                            <img src="<?php echo e(asset(setting('logo'))); ?>" alt="logo" class="img-fluid" width="200">
                        </div>
                        <div class="col-auto text-end">
                            <h5 class="mb-0">Invoice
                                <span
                                    class="text-accent"><?php echo e(setting('inv_prefix')); ?><?php echo e($data->booking->resource->id); ?>

                                </span>
                            </h5>
                            <span class="text-muted">Invoice Date:
                                <?php echo e(date('d M, Y', strtotime($data->booking->resource->created_at))); ?>

                            </span>
                        </div>
                    </div>
                    <div class="d-flex justify-content-md-between justify-content-center g-3">
                        <div class="col-auto">
                            <!--Customer Detail-->
                            <div class="welcome-message">
                                <h5 class="mb-2">Customer Info</h6>
                                    <p class="mb-0">Name: <strong><?php echo e(optional($data->booking->resource->user)->full_name); ?></strong></p>
                                    <p class="mb-0">Email: <strong><?php echo e(optional($data->booking->resource->user)->email); ?></strong></p>
                                    <p class="mb-0">Phone: <strong><?php echo e(optional($data->booking->resource->user)->mobile); ?></strong></p>
                            </div>
                            <div class="col-auto mt-3">
                                <h6 class="d-inline-block">Payment Method: </h6>
                                <span class="badge bg-primary"><?php echo e(ucwords(str_replace('_', ' ', $data->booking_transaction->transaction_type))); ?></span>
                            </div>
                        </div>
                        <div class="col-auto">
                            <?php
                                $billingAddress = $data->booking->resource->user->address;
                            ?>
                            <?php if($billingAddress): ?>
                                <div class="shipping-address d-flex justify-content-md-end gap-3 mb-3" style="min-width: 500px">
                                    <div class="w-25">
                                        <h5 class="mb-2">Billing Address</h5>
                                        <p class="mb-0 text-wrap">

                                            <?php echo e(optional($billingAddress)->address_line_1); ?>,
                                            <?php echo e(optional($billingAddress->city_data)->name); ?>,
                                            <?php echo e(optional($billingAddress->state_data)->name); ?>,
                                            <?php echo e(optional($billingAddress->country_data)->name); ?>

                                        </p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!--order details-->
                <table class="table table-bordered border-top" data-use-parent-width="true">
                    <thead>
                        <tr>
                            <th>Services / Products</th>
                            <th>Unit Price</th>
                            <th>QTY</th>
                            <th class="text-end">Total Price</th>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__currentLoopData = $data->booking->resource->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="ms-2">
                                        <h6 class="fs-sm mb-0">
                                            <?php echo e($value->service_name); ?>

                                        </h6>
                                    </div>
                                </div>
                            </td>

                            <td class="">
                                <span class="fw-bold"><?php echo e(\Currency::format($value->service_price)); ?>

                                </span>
                            </td>

                            <td class="fw-bold">1</td>

                            <td class=" text-end">
                                <span class="text-accent fw-bold"><?php echo e(\Currency::format($value->service_price)); ?>

                                </span>

                            </td>

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $data->booking->resource->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="ms-2">
                                            <h6 class="fs-sm mb-0">
                                                <?php echo e($value->product_name); ?>

                                            </h6>
                                        </div>
                                    </div>
                                </td>
                                <?php
                                    $price = $value->product_price;
                                    $delPrice = false;
                                    $discountType = $value->discount_type;
                                    $discountValue = $value->discount_value . ($discountType == 'percent' ? '%' : '');
                                    if($price != $value->discounted_price) {
                                        $delPrice = $price;
                                        $price = $value->discounted_price;
                                    }
                                ?>
                                <td class="">
                                    <div class="d-flex gap-3 align-items-center">
                                        <span class="fw-bold">
                                            <?php echo e(\Currency::format($price)); ?>

                                        </span>
                                    </div>
                                </td>
                                <td class="fw-bold"><?php echo e($value->product_qty); ?></td>

                                <td class=" text-end">
                                    <span class="text-accent fw-bold"><?php echo e(\Currency::format($price * $value->product_qty)); ?>

                                    </span>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot class="text-end">
                        <tr>
                            <td colspan="3">
                                <h6 class="d-inline-block me-3">Sub Total: </h6>
                            </td>
                            <td width="10%">
                                <strong><?php echo e(\Currency::format($data->services_total_amount + $data->product_amount)); ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <h6 class="d-inline-block me-3">Tips: </h6>
                            </td>
                            <td width="10%" class="text-end">
                                <strong><?php echo e(\Currency::format($data->booking_transaction->tip_amount)); ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <h6 class="d-inline-block me-3">TAX: </h6>
                            </td>
                            <td width="10%" class="text-end">
                                <strong><?php echo e(\Currency::format($data->tax_amount)); ?></strong></td>
                        </tr>
                        <tr>
                            <td colspan="3">
                                <h6 class="d-inline-block me-3">Grand Total: </h6>
                            </td>
                            <td width="10%" class="text-end"><strong
                                    class="text-accent"><?php echo e(\Currency::format($data->grand_total)); ?></strong>
                            </td>
                        </tr>
                    </tfoot>
                </table>

                <!--Note-->
                <div class="card-body">
                    <div class="card-footer border-top-0 px-4 py-4 rounded bg-soft-gray border border-2">
                        <p class="mb-0"><?php echo e(setting('spacial_note')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after-scripts'); ?>
    <script>
        function invoicePrint() {
            window.print()
        }

        function updateStatusAjax(__this, url) {
            $.ajax({
                url: url,
                type: 'POST',
                dataType: 'json',
                data: {
                    order_id: <?php echo e($data->booking->resource->id); ?>,
                    status: __this.val(),
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                success: function(res) {
                    if (res.status) {
                        window.successSnackbar(res.message)
                        setTimeout(() => {
                            location.reload()
                        }, 100);
                    }
                }
            });
        }
        $('[name="payment_status"]').on('change', function() {
            if ($(this).val() !== '') {
                updateStatusAjax($(this), "<?php echo e(route('backend.orders.update_payment_status')); ?>")
            }
        })

        $('[name="delivery_status"]').on('change', function() {
            if ($(this).val() !== '') {
                updateStatusAjax($(this), "<?php echo e(route('backend.orders.update_delivery_status')); ?>")
            }
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/frezka/Modules/Booking/Resources/views/backend/invoice.blade.php ENDPATH**/ ?>